#include <stdio.h>
#include <string.h>
#include <allegro.h>

#define MAX_WIDTH 300

void DrawMapTile(int, int, int);

void main(void)
{
   FILE* rom;
   int   tile[24792];
   int   currX = 0;
   int   currY = 0;
   int   kee = KEY_K;

   allegro_init();
   install_keyboard();
   set_color_depth(16);
   set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0);

   rom = fopen("ebtest.smc", "rb");

   fseek(rom, 0x160200, SEEK_SET);

   for (int i = 0; i < 24792; i++)
      tile[i] = fgetc(rom);

   fclose(rom);

   while (kee != KEY_ESC)
   {
      kee = readkey() >> 8;

      switch (kee)
      {
         case KEY_LEFT:
         {
            currX--;
            if (currX < 0)
               currX = 0;

            break;
         }

         case KEY_RIGHT:
         {
            currX++;
            if (currX > (MAX_WIDTH - 20))
               currX = MAX_WIDTH - 20;

            break;
         }
      }

      clear(screen);

      for (int y = 0; y < 15; y++)
      {
         for (int x = 0; x < 20; x++)
         {
            DrawMapTile(x * 32, y * 32, tile[MAX_WIDTH * (y + currY) + (x + currX)]);
         }
      }      
   }
}


void DrawMapTile(int x, int y, int tileNum)
{
   char    filename[25];
   BITMAP* tile;

   sprintf(filename, "tile_%x.bmp", tileNum);

   tile = load_bmp(filename, NULL);
   if (tile != NULL)
   {
      blit(tile, screen, 0, 0, x, y, 32, 32);
      destroy_bitmap(tile);
   }
   else
   {
      rectfill(screen, x, y, x + 32, y + 32, makecol16(0, 0, 0));
   }
}
