#include <stdio.h>

int main(int argc, char* argv[])
{
   FILE* rom;
   long  loc;
   long  loc2;
   long  tpointer;
   int   tableOffset = 0;

   unsigned char ch;
   unsigned char prev_ch;

   if (argc < 2)
   {
      printf("Usage: tpointer rom.smc\n");
      return -1;
   }

   rom = fopen(argv[1], "rb");
   if (!rom)
   {
      printf("Error opening %s!\n", argv[1]);
      return -1;
   }

   for (int i = 0; i < 512; i++)
   {
      tpointer = 0x50200 + 7 * tableOffset;

      tpointer += 2 * (tableOffset / 58);
      tpointer += 2 * (tableOffset / 380);

      fseek(rom, tpointer, SEEK_SET);

      ch = fgetc(rom);
      ch = fgetc(rom);
      ch = fgetc(rom);
      ch = fgetc(rom);

      loc = fgetc(rom);
      loc += (fgetc(rom) << 8);
      loc += (fgetc(rom) << 16);
      loc2 = loc;

      loc -= 0xc00000;
      loc += 0x200;

      printf("%d\t0x%X -> 0x%X : $%X\n", tableOffset, tpointer, loc, loc2);

      tableOffset++;
   }

   fclose(rom);

   return 0;
}
