#include <stdio.h>
#include <allegro.h>
#include "spriteconv.h"

struct OSprite
{
   unsigned int  address;
   unsigned char width;
   unsigned char height;
   unsigned char palette;
};

void DrawTile(FILE* rom, long address, int xx, int yy, int pal, unsigned char sprite[80][64]);
void GetSprite(FILE* rom, int spriteNum, unsigned char sprite[80][64], int&, int&);
void InitOSpriteArray(OSprite[]);
void ChangePalette(void);

int main(int argc, char* argv[])
{
   FILE*         rom;
   unsigned char sprite[80][64];
   int           num = 0;
   int           kee = 9;
   int           w;
   int           h;

   if (argc < 2)
   {
      printf("Usage: sprtest rom.smc\n");
      return -1;
   }

   rom = fopen(argv[1], "rb");
   if (!rom)
   {
      printf("Unable to open %s!\n", argv[1]);
      return -1;
   }

   allegro_init();
   install_keyboard();
   set_color_depth(8);
   set_gfx_mode(GFX_VGA, 320, 200, 0, 0);

   ChangePalette();

   while (kee != KEY_ESC)
   {
      clear(screen);

      for (int j = 0; j < 5; j++)
      {
         GetSprite(rom, sprConv[num + j], sprite, w, h);

         for (int y = 0; y < 80; y++)
         {
            for (int x = 0; x < 64; x++)
            {
               putpixel(screen, (64 * j) + x, 10 + y, sprite[y][x]);
            }
         }

         textprintf(screen, font, (64 * j) + 15, 0, 255, "%d", sprConv[num + j]);
      }
      for (int j = 0; j < 5; j++)
      {
         GetSprite(rom, sprConv[num + 5 + j], sprite, w, h);

         for (int y = 0; y < 80; y++)
         {
            for (int x = 0; x < 64; x++)
            {
               putpixel(screen, (64 * j) + x, y + 110, sprite[y][x]);
            }
         }

         textprintf(screen, font, (64 * j) + 15, 100, 255, "%d", sprConv[num + 5 + j]);
      }

      textprintf(screen, font, 0, 190, 255, "%d", num);

      kee = readkey() >> 8;

      switch(kee)
      {
         case KEY_LEFT:
         {
            num -= 10;
            if (num < 0)
               num = 0;

            break;
         }
         case KEY_RIGHT:
         {
            num += 10;
            if (num >= 454)
               num = 454;

            break;
         }
      }
   }

   fclose(rom);

   return 0;
}

void DrawTile(FILE* rom, long address, int xx, int yy, int pal, unsigned char sprite[80][64])
{
   unsigned char ch;
   int           i;
   int           y;
   char          sprLine[8][8];

   fseek(rom, address, SEEK_SET);

   for (y = 0; y < 8; y++)
   {
      ch = fgetc(rom);

      for (i = 0; i < 8; i++)
         sprLine[y][7 - i] = (ch & (1 << i)) >> i;

      ch = fgetc(rom);

      for (i = 0; i < 8; i++)
         sprLine[y][7 - i] += ((ch & (1 << i)) >> i) << 1;
   }

   for (y = 0; y < 8; y++)
   {
      ch = fgetc(rom);

      for (i = 0; i < 8; i++)
         sprLine[y][7 - i] += ((ch & (1 << i)) >> i) << 2;

      ch = fgetc(rom);

      for (i = 0; i < 8; i++)
         sprLine[y][7 - i] += ((ch & (1 << i)) >> i) << 3;
   }

   for (y = 0; y < 8; y++)
   {
      for (i = 0; i < 8; i++)
      {
         if (sprLine[y][i] == 0)
            sprite[yy + y][xx + i] = 0;
         else
            sprite[yy + y][xx + i] = (16 * pal) + sprLine[y][i];
      }
   }
}

void GetSprite(FILE* rom, int spriteNum, unsigned char sprite[80][64], int& width, int& height)
{
   // width and height and palette will have to be predetermined and then
   // selected in this function.  Calling functions do not require this info.
   // Same goes for address of each sprite.  This function just takes a
   // sprite "number", which is determined by where it appears in the rom.

   static OSprite osprite[2000];  // DJGPP doesn't like 1144 for some reason
   static int     firstTime = 1;
   unsigned int   address   = 0;
   int            offset    = 0;
   int            pal       = 0;

   if (firstTime == 1)
   {
      InitOSpriteArray(osprite);
      firstTime = 0;
   }

   address = osprite[spriteNum].address;
   width = osprite[spriteNum].width;
   height = osprite[spriteNum].height;
   pal = osprite[spriteNum].palette;

   for (int y = 0; y < 80; y++)
   {
      for (int x = 0; x < 64; x++)
      {
         sprite[y][x] = 0;
      }
   }

//   if (pal == 4)
//{
   for (int a = 0; a < height; a++)
   {
      for (int i = 0; i < width; i++)
      {
         DrawTile(rom, address + offset, i * 8, a * 8, pal, sprite);
         offset += 32;
      }
   }
//}
}

void ChangePalette(void)
{
   // In this program, RGB values can only go from 0 to 63, but you'll probably need
   // to translate those into 0-256 values for Windows.  It's easy, just multiply each
   // each R, G, and B entries by 4.

   // Not all colors in all the sprites are correct yet, but most are.  However,
   // in later versions of PK Hack, this palette stuff will be totally redone, cuz I'll
   // actually be doing some major palette-related hacking in the near future.  When I do
   // that, I'll probably have the true way palettes are handled.  This is a problem
   // not in the getsprite routines, but we'll encounter the problems when we get to
   // sprite editing.  Don't you just love theoretical ROM hacking?

   RGB globalPal[256] =
   { {  0,  0,  0 },  // Color 0
     { 60, 60, 60 },  // Color 1
     { 50, 50, 50 },  // Color 2
     { 36, 40, 32 },  // Color 3, and so forth...
     {  0, 40, 32 },
     {  0, 32, 28 },
     { 20, 28, 24 },
     { 60, 44, 36 },
     { 50, 38, 30 },
     { 60, 36, 36 },
     { 60,  0, 24 },
     { 36,  0,  6 },
     { 56, 52,  8 },
     { 60, 36,  0 },
     { 28, 28, 60 },
     { 12,  8,  8 },

     {  0,  0,  0 },
     { 60, 62, 62 },
     { 42, 42, 42 },
     { 34, 34, 34 },
     { 38, 30, 11 },
     { 60, 12, 16 },
     { 56, 52,  8 },
     { 60, 37,  0 },
     { 50, 38, 30 },
     { 60, 36, 36 },
     { 60,  0, 24 },
     { 20, 30, 24 },
     { 56, 52,  8 },
     { 48, 52, 38 },
     { 36, 38, 24 },
     { 12,  8,  8 },

     {  0,  0,  0 },
     { 60, 60, 44 },
     { 48, 44, 32 },
     { 48, 40, 26 },
     { 38, 30, 22 },
     { 32, 24, 16 },
     { 20, 16, 10 },
     { 60, 44, 36 },
     { 50, 38, 30 },
     { 20, 28, 22 },
     { 60, 44, 36 },
     { 60, 36, 36 },
     { 40, 34, 60 },
     { 28, 22, 56 },
     { 28, 28, 60 },
     { 12,  8,  8 },

     {  0,  0,  0 },
     { 60, 60, 44 },
     { 48, 44, 32 },
     { 48, 40, 26 },
     { 38, 30, 22 },
     { 32, 24, 16 },
     { 20, 16, 10 },
     {  0, 44, 32 },
     {  0, 36, 28 },
     { 20, 28, 22 },
     { 60, 44, 36 },
     { 60, 36, 36 },
     { 60, 60, 60 },
     { 50, 50, 50 },
     { 60, 60, 60 },
     { 12,  8,  8 },

     {  0,  0,  0 },
     { 24, 32, 62 },
     { 62, 62, 62 },
     { 28, 28, 60 },
     { 22, 18, 38 },
     { 32, 24, 16 },
     { 20, 16, 10 },
     { 60, 44, 36 },
     { 62, 62, 62 },
     { 18, 20, 20 },
     { 20, 28, 22 },
     { 60, 44, 36 },
     { 60, 36, 36 },
     { 40, 34, 60 },
     { 28, 22, 56 },
     { 20,  0, 30 },
     { 12,  8,  8 }
   };

   globalPal[255].r = 63;
   globalPal[255].g = 63;
   globalPal[255].b = 63;

   set_palette(globalPal);
}


void InitOSpriteArray(OSprite osprite[])
{
#include "osprites.h"
}

