#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <allegro.h>

void DrawTile(FILE*, long, int, int);
void DrawSprite(FILE*, long, int, int, int, int);
void ChangePalette1(void);
void ChangePalette2(void);
void ChangePalette3(void);

int main(int argc, char* argv[])
{
   FILE* rom;
   FILE* f_out;
   int   kee    = 99;
   long  loc    = 0x110280;
   int   width  = 4;
   int   height = 24;
   int   pal    = 1;
   int   count  = 0;
   long  last_loc = 0;

   if (argc < 3)
   {
      printf("Usage: sprite rom.smc output_file\n");
      return -1;
   }

   rom = fopen(argv[1], "rb");
   if (!rom)
   {
      printf("Unable to open %s, aborting.\n", argv[1]);
      return -1;
   }

   if (argc = 4)
      count = atoi(argv[3]);

   f_out = fopen(argv[2], "a");

   allegro_init();

   install_keyboard();

   set_color_depth(8);
   set_gfx_mode(GFX_VGA, 320, 200, 0, 0);
   text_mode(-1);

   ChangePalette1();

   while (kee != KEY_ESC)
   {
      clear(screen);
      DrawSprite(rom, loc, width, height, 1, 1);
      rect(screen, 0, 0, width * 8 + 1, height * 8 + 1, 255);
      textprintf(screen, font, 230, 0, 255, "0x%x", loc);
      textprintf(screen, font, 230, 10, 255, "Width:  %d", width);
      textprintf(screen, font, 230, 20, 255, "Height: %d", height);
      textprintf(screen, font, 230, 30, 255, "Pal. #: %d", pal);

      textprintf(screen, font, 230, 50, 255, "Count:  %d", count);

      kee = readkey() >> 8;

      switch(kee)
      {
         case KEY_LEFT:
         {
            width--;
            if (width < 1)
               width = 1;
            break;
         }
         case KEY_RIGHT:
         {
            width++;
            if (width > 28)
               width = 28;
            break;
         }
         case KEY_UP:
         {
            height--;
            if (height < 0)
               height = 1;
            break;
         }
         case KEY_DOWN:
         {
            height++;
            if (height > 24)
               height = 24;
            break;
         }
         case KEY_PGUP:
         {
            loc -= 0x20;
            break;
         }
         case KEY_PGDN:
         {
            loc += 0x20;
            break;
         }
         case KEY_END:
         {
            loc += 0x20 * width;
            break;
         }
         case KEY_ENTER:
         {
            loc += 0x20 * width * height;
            break;
         }
         case KEY_1:
         {
            ChangePalette1();
            pal = 1;
            break;
         }
         case KEY_2:
         {
            ChangePalette2();
            pal = 2;
            break;
         }
         case KEY_3:
         {
            ChangePalette3();
            pal = 3;
            break;
         }
         case KEY_TAB:
         {
            if (last_loc == loc)
               break;

            fprintf(f_out, "osprite[%d].address = 0x%x;\n", count, loc);
            fprintf(f_out, "osprite[%d].width   = %d;\n", count, width);
            fprintf(f_out, "osprite[%d].height  = %d;\n", count, height);
            fprintf(f_out, "osprite[%d].palette = %d;\n\n", count, pal - 1);

            count++;
            last_loc = loc;
         }
      }
   }

   fclose(rom);
   fclose(f_out);

   return 0;
}


void DrawTile(FILE* rom, long address, int xx, int yy)
{
   unsigned char ch;
   int           i;
   int           y;
   char          sprLine[8][8];

   fseek(rom, address, SEEK_SET);

   for (y = 0; y < 8; y++)
   {
      ch = fgetc(rom);

      for (i = 0; i < 8; i++)
         sprLine[y][7 - i] = (ch & (1 << i)) >> i;

      ch = fgetc(rom);

      for (i = 0; i < 8; i++)
         sprLine[y][7 - i] += ((ch & (1 << i)) >> i) << 1;
   }

   for (y = 0; y < 8; y++)
   {
      ch = fgetc(rom);

      for (i = 0; i < 8; i++)
         sprLine[y][7 - i] += ((ch & (1 << i)) >> i) << 2;

      ch = fgetc(rom);

      for (i = 0; i < 8; i++)
         sprLine[y][7 - i] += ((ch & (1 << i)) >> i) << 3;
   }

   for (y = 0; y < 8; y++)
   {
      for (i = 0; i < 8; i++)
      {
         putpixel(screen, xx + i, yy + y, sprLine[y][i]);
      }
   }
}


void DrawSprite(FILE* rom, long address, int width, int height, int x, int y)
{
   int offset = 0;

   for (int a = 0; a < height; a++)
   {
      for (int i = 0; i < width; i++)
      {
         DrawTile(rom, address + offset, x + i * 8, y + a * 8);
         offset += 32;
      }
   }
}


void ChangePalette1(void)
{
   RGB hi;

   hi.r = 60;
   hi.g = 60;
   hi.b = 60;
   set_color(1, &hi);

   hi.r = 50;
   hi.g = 50;
   hi.b = 50;
   set_color(2, &hi);

   hi.r = 144 / 4;
   hi.g = 160 / 4;
   hi.b = 128 / 4;
   set_color(3, &hi);

   hi.r = 0;
   hi.g = 160 / 4;
   hi.b = 128 / 4;
   set_color(4, &hi);

   hi.r = 0;
   hi.g = 128 / 4;
   hi.b = 112 / 4;
   set_color(5, &hi);

   hi.r = 20;
   hi.g = 112 / 4;
   hi.b = 96 / 4;
   set_color(6, &hi);

   hi.r = 240 / 4;
   hi.g = 176 / 4;
   hi.b = 144 / 4;
   set_color(7, &hi);

   hi.r = 200 / 4;
   hi.g = 152 / 4;
   hi.b = 120 / 4;
   set_color(8, &hi);

   hi.r = 240 / 4;
   hi.g = 144 / 4;
   hi.b = 144 / 4;
   set_color(9, &hi);

   hi.r = 240 / 4;
   hi.g = 0;
   hi.b = 96 / 4;
   set_color(10, &hi);

   hi.r = 144 / 4;
   hi.g = 0;
   hi.b = 6;
   set_color(11, &hi);

   hi.r = 224 / 4;
   hi.g = 208 / 4;
   hi.b = 8;
   set_color(12, &hi);

   hi.r = 60;
   hi.g = 144 / 4;
   hi.b = 0;
   set_color(13, &hi);

   hi.r = 112 / 4;
   hi.g = 112 / 4;
   hi.b = 240 / 4;
   set_color(14, &hi);

   hi.r = 12;
   hi.g = 8;
   hi.b = 8;
   set_color(15, &hi);

   hi.r = 63;
   hi.g = 63;
   hi.b = 63;
   set_color(255, &hi);
}

void ChangePalette2(void)
{
   RGB hi;

   hi.r = 60;
   hi.g = 248 / 4;
   hi.b = 248 / 4;
   set_color(1, &hi);

   hi.r = 168 / 4;
   hi.g = 168 / 4;
   hi.b = 168 / 4;
   set_color(2, &hi);

   hi.r = 136 / 4;
   hi.g = 136 / 4;
   hi.b = 136 / 4;
   set_color(3, &hi);

   hi.r = 152 / 4;
   hi.g = 120 / 4;
   hi.b = 88 / 4;
   set_color(4, &hi);

   hi.r = 240 / 4;
   hi.g = 48 / 4;
   hi.b = 64 / 4;
   set_color(5, &hi);

   hi.r = 224 / 4;
   hi.g = 208 / 4;
   hi.b = 32 / 4;
   set_color(6, &hi);

   hi.r = 240 / 4;
   hi.g = 148 / 4;
   hi.b = 0;
   set_color(7, &hi);

   hi.r = 200 / 4;
   hi.g = 152 / 4;
   hi.b = 120 / 4;
   set_color(8, &hi);

   hi.r = 240 / 4;
   hi.g = 144 / 4;
   hi.b = 144 / 4;
   set_color(9, &hi);

   hi.r = 240 / 4;
   hi.g = 0;
   hi.b = 96 / 4;
   set_color(10, &hi);

   hi.r = 80 / 4;
   hi.g = 120 / 4;
   hi.b = 96 / 4;
   set_color(11, &hi);

//   hi.r = 144 / 4;
//   hi.g = 0;
//   hi.b = 6;
//   set_color(11, &hi);

   hi.r = 224 / 4;
   hi.g = 208 / 4;
   hi.b = 8;
   set_color(12, &hi);

   hi.r = 192 / 4;
   hi.g = 208 / 4;
   hi.b = 152 / 4;
   set_color(13, &hi);

   hi.r = 144 / 4;
   hi.g = 152 / 4;
   hi.b = 96 / 4;
   set_color(14, &hi);

   hi.r = 12;
   hi.g = 8;
   hi.b = 8;
   set_color(15, &hi);

   hi.r = 63;
   hi.g = 63;
   hi.b = 63;
   set_color(255, &hi);
}






void ChangePalette3(void)
{
   RGB hi;

   // Done
   hi.r = 240 / 4;
   hi.g = 240 / 4;
   hi.b = 176 / 4;
   set_color(1, &hi);

   // Done
   hi.r = 192 / 4;
   hi.g = 176 / 4;
   hi.b = 128 / 4;
   set_color(2, &hi);

   hi.r = 192 / 4;
   hi.g = 160 / 4;
   hi.b = 104 / 4;
   set_color(3, &hi);

   // Done
   hi.r = 152 / 4;
   hi.g = 120 / 4;
   hi.b = 88 / 4;
   set_color(4, &hi);

   // Done
   hi.r = 128 / 4;
   hi.g = 96 / 4;
   hi.b = 64 / 4;
   set_color(5, &hi);

   hi.r = 20;
   hi.g = 112 / 4;
   hi.b = 96 / 4;
   set_color(6, &hi);

   hi.r = 240 / 4;
   hi.g = 176 / 4;
   hi.b = 144 / 4;
   set_color(7, &hi);

   hi.r = 200 / 4;
   hi.g = 152 / 4;
   hi.b = 120 / 4;
   set_color(8, &hi);

   // Done
   hi.r = 80 / 4;
   hi.g = 112 / 4;
   hi.b = 88 / 4;
   set_color(9, &hi);

   // Done
   hi.r = 240 / 4;
   hi.g = 176 / 4;
   hi.b = 144 / 4;
   set_color(10, &hi);

   hi.r = 144 / 4;
   hi.g = 0;
   hi.b = 6;
   set_color(11, &hi);

   // Done
   hi.r = 160 / 4;
   hi.g = 136 / 4;
   hi.b = 240 / 4;
   set_color(12, &hi);

   // Done
   hi.r = 112 / 4;
   hi.g = 88 / 4;
   hi.b = 224 / 4;
   set_color(13, &hi);

   hi.r = 112 / 4;
   hi.g = 112 / 4;
   hi.b = 240 / 4;
   set_color(14, &hi);

   // Done
   hi.r = 12;
   hi.g = 8;
   hi.b = 8;
   set_color(15, &hi);

   hi.r = 63;
   hi.g = 63;
   hi.b = 63;
   set_color(255, &hi);
}
