#include <stdio.h>

#define MEMBER_NESS  0
#define MEMBER_PAULA 1
#define MEMBER_JEFF  2
#define MEMBER_POO   3

struct SSPartyMember
{
   char name[6];

   unsigned char level;
   unsigned int  exp;

   unsigned int hp;
   unsigned int maxHp;
   unsigned int rollHp;
   unsigned int pp;
   unsigned int maxPp;
   unsigned int rollPp;

   unsigned char offense;
   unsigned char defense;
   unsigned char speed;
   unsigned char guts;
   unsigned char luck;
   unsigned char vitality;
   unsigned char iq;
   
   unsigned char item[14];
};

struct SaveState
{
   void ChangeMoney(FILE*, unsigned int);
   void ChangeATM(FILE*, unsigned int);
   void ChangeMemberName(FILE*, char*, int);
   void ChangeMemberLevel(FILE*, unsigned char, int);
   void ChangeMemberExp(FILE*, unsigned int, int);
   void ChangeMemberHP(FILE*, int, int);
   void ChangeMemberMaxHP(FILE*, int, int);
   void ChangeMemberRollHP(FILE*, int, int);
   void ChangeMemberPP(FILE*, int, int);
   void ChangeMemberMaxPP(FILE*, int, int);
   void ChangeMemberRollPP(FILE*, int, int);
   void ChangeMemberOffense(FILE*, unsigned char, int);
   void ChangeMemberDefense(FILE*, unsigned char, int);
   void ChangeMemberSpeed(FILE*, unsigned char, int);
   void ChangeMemberGuts(FILE*, unsigned char, int);
   void ChangeMemberLuck(FILE*, unsigned char, int);
   void ChangeMemberVitality(FILE*, unsigned char, int);
   void ChangeMemberIQ(FILE*, unsigned char, int);
   void ChangeMemberItem(FILE*, unsigned char, int, int);

   unsigned int  money;
   unsigned int  atm;
   SSPartyMember member[4];
};

void PullSaveState(FILE*, SaveState&);


int main(int argc, char* argv[])
{
   FILE*     rom;
   SaveState ss;

   if (argc < 2)
   {
      printf("Usage: savestate rom.smc\n");
      return -1;
   }

   rom = fopen(argv[1], "rb+");
   if (!rom)
   {
      printf("Error opening %s!\n", argv[1]);
      return -1;
   }

   PullSaveState(rom, ss);
   ss.ChangeMemberItem(rom, 105, 10, 0);

   fclose(rom);
/*
   printf("Money: %d\n", ss.money);
   printf("ATM:   %d\n\n", ss.atm);

   for (int j = 0; j < 4; j++)
   {
      printf("Name:     %s\n", ss.member[j].name);
      printf("Level:    %d\n", ss.member[j].level);
      printf("EXP:      %d\n", ss.member[j].exp);
      printf("HP:       %d / %d\n", ss.member[j].hp, ss.member[j].maxHp);
      printf("Roll HP:  %d\n", ss.member[j].rollHp);
      printf("PP:       %d / %d\n", ss.member[j].pp, ss.member[j].maxPp);
      printf("Roll PP:  %d\n", ss.member[j].rollPp);
      printf("Offense:  %d\n", ss.member[j].offense);
      printf("Defense:  %d\n", ss.member[j].defense);
      printf("Speed:    %d\n", ss.member[j].speed);
      printf("Guts:     %d\n", ss.member[j].guts);
      printf("Luck:     %d\n", ss.member[j].luck);
      printf("Vitality: %d\n", ss.member[j].vitality);
      printf("IQ:       %d\n", ss.member[j].iq);

      printf("\nItems:\n\n");

      for (int i = 0; i < 7; i++)
      {
         printf("%d\t%d\n", ss.member[j].item[i * 2],
                            ss.member[j].item[i * 2 + 1]);
      }

      printf("\n");
   }*/

   return 0;
}

void PullSaveState(FILE* rom, SaveState& saveState)
{
   // Assumes rom is in read binary mode

   int i;
   int j;

   fseek(rom, 0xa444, SEEK_SET);
   saveState.money = fgetc(rom);
   saveState.money += (fgetc(rom) << 8);
   saveState.money += (fgetc(rom) << 16);
   saveState.money += (fgetc(rom) << 24);

   saveState.atm = fgetc(rom);
   saveState.atm += (fgetc(rom) << 8);
   saveState.atm += (fgetc(rom) << 16);
   saveState.atm += (fgetc(rom) << 24);

   for (j = 0; j < 4; j++)
   {
      fseek(rom, 0xa5e1 + (j * 0x5f), SEEK_SET);
      for (i = 0; i < 5; i++)
         saveState.member[j].name[i] = fgetc(rom) - 48;

      saveState.member[j].name[5] = '\0';

      fseek(rom, 0xa5e6 + (j * 0x5f), SEEK_SET);
      saveState.member[j].level = fgetc(rom);

      saveState.member[j].exp = fgetc(rom);
      saveState.member[j].exp += (fgetc(rom) << 8);
      saveState.member[j].exp += (fgetc(rom) << 16);
      saveState.member[j].exp += (fgetc(rom) << 24);

      fseek(rom, 0xa5eb + (j * 0x5f), SEEK_SET);
      saveState.member[j].maxHp = fgetc(rom);
      saveState.member[j].maxHp += (fgetc(rom) << 8);

      saveState.member[j].maxPp = fgetc(rom);
      saveState.member[j].maxPp += (fgetc(rom) << 8);

      fseek(rom, 0xa5f6 + (j * 0x5f), SEEK_SET);
      saveState.member[j].offense = fgetc(rom);
      saveState.member[j].defense = fgetc(rom);
      saveState.member[j].speed = fgetc(rom);
      saveState.member[j].guts = fgetc(rom);
      saveState.member[j].luck = fgetc(rom);
      saveState.member[j].vitality = fgetc(rom);
      saveState.member[j].iq = fgetc(rom);

      fseek(rom, 0xa604 + (j * 0x5f), SEEK_SET);
      for (i = 0; i < 14; i++)
         saveState.member[j].item[i] = fgetc(rom);

      fseek(rom, 0xa626 + (j * 0x5f), SEEK_SET);
      saveState.member[j].rollHp = fgetc(rom);
      saveState.member[j].rollHp += (fgetc(rom) << 8);

      saveState.member[j].hp = fgetc(rom);
      saveState.member[j].hp += (fgetc(rom) << 8);

      fseek(rom, 0xa62c + (j * 0x5f), SEEK_SET);
      saveState.member[j].rollPp = fgetc(rom);
      saveState.member[j].rollPp += fgetc(rom);

      saveState.member[j].pp = fgetc(rom);
      saveState.member[j].pp += (fgetc(rom) << 8);
   }
}


void SaveState::ChangeMoney(FILE* rom, unsigned int newValue)
{
   // Assumes rom is in write binary mode
   // Allowed values for newValue are 0 to 99,999.  Any larger values
   // messes the game up.

   fseek(rom, 0xa444, SEEK_SET);
   fflush(rom);

   fputc(newValue & 255, rom);
   fputc((newValue >> 8) & 255, rom);
   fputc((newValue >> 16) & 255, rom);
   fputc((newValue >> 24) & 255, rom);

   money = newValue;
}

void SaveState::ChangeATM(FILE* rom, unsigned int newValue)
{
   // Assumes rom is in write binary mode
   // Allowed values for newValue are 0 to 9,999,999.  Any larger values
   // can screw the game up.

   fseek(rom, 0xa448, SEEK_SET);
   fflush(rom);

   fputc(newValue & 255, rom);
   fputc((newValue >> 8) & 255, rom);
   fputc((newValue >> 16) & 255, rom);
   fputc((newValue >> 24) & 255, rom);

   atm = newValue;
}


void SaveState::ChangeMemberName(FILE* rom, char* newValue, int index)
{
   // Assumes rom is in write binary mode
   // newValue must be 6 characters long at most, and the final
   // character has to be null.  This means character names can only
   // have five readable characters.
   // index can be one of the party members #defined above

   fseek(rom, 0xa5e1 + (index * 0x5f), SEEK_SET);
   fflush(rom);

   for (int i = 0; i < 5; i++)
   {
      fputc(newValue[i] + 48, rom);
      member[index].name[i] = newValue[i];
   }
}

void SaveState::ChangeMemberLevel(FILE* rom, unsigned char newValue, int index)
{
   // Assumes rom is in write binary mode
   // index can be one of the party members #defined above

   fseek(rom, 0xa5e6 + (index * 0x5f), SEEK_SET);
   fflush(rom);

   fputc(newValue, rom);

   member[index].level = newValue;
}

void SaveState::ChangeMemberExp(FILE* rom, unsigned int newValue, int index)
{
   // Assumes rom is in write binary mode
   // Too big of a number might cause the game to freak out, but that's just
   // my guess...
   // index can be one of the party members #defined above

   fseek(rom, 0xa5e7 + (index * 0x5f), SEEK_SET);
   fflush(rom);

   fputc(newValue & 255, rom);
   fputc((newValue >> 8) & 255, rom);
   fputc((newValue >> 16) & 255, rom);
   fputc((newValue >> 24) & 255, rom);

   member[index].exp = newValue;
}

void SaveState::ChangeMemberMaxHP(FILE* rom, int newValue, int index)
{
   // Assumes rom is in write binary mode
   // Values for newValue are from 0 to 65535
   // index can be one of the party members #defined above

   fseek(rom, 0xa5eb + (index * 0x5f), SEEK_SET);
   fflush(rom);

   fputc(newValue & 255, rom);
   fputc((newValue >> 8) & 255, rom);

   member[index].maxHp = newValue;
}

void SaveState::ChangeMemberMaxPP(FILE* rom, int newValue, int index)
{
   // Assumes rom is in write binary mode
   // Values for newValue are from 0 to 65535
   // index can be one of the party members #defined above

   fseek(rom, 0xa5ed + (index * 0x5f), SEEK_SET);
   fflush(rom);

   fputc(newValue & 255, rom);
   fputc((newValue >> 8) & 255, rom);

   member[index].maxPp = newValue;
}

void SaveState::ChangeMemberOffense(FILE* rom, unsigned char newValue, int index)
{
   // Assumes rom is in write binary mode
   // index can be one of the party members #defined above

   fseek(rom, 0xa5f6 + (index * 0x5f), SEEK_SET);
   fflush(rom);

   fputc(newValue, rom);

   member[index].offense = newValue;
}

void SaveState::ChangeMemberDefense(FILE* rom, unsigned char newValue, int index)
{
   // Assumes rom is in write binary mode
   // index can be one of the party members #defined above

   fseek(rom, 0xa5f7 + (index * 0x5f), SEEK_SET);
   fflush(rom);

   fputc(newValue, rom);

   member[index].defense = newValue;
}

void SaveState::ChangeMemberSpeed(FILE* rom, unsigned char newValue, int index)
{
   // Assumes rom is in write binary mode
   // index can be one of the party members #defined above

   fseek(rom, 0xa5f8 + (index * 0x5f), SEEK_SET);
   fflush(rom);

   fputc(newValue, rom);

   member[index].speed = newValue;
}

void SaveState::ChangeMemberGuts(FILE* rom, unsigned char newValue, int index)
{
   // Assumes rom is in write binary mode
   // index can be one of the party members #defined above

   fseek(rom, 0xa5f9 + (index * 0x5f), SEEK_SET);
   fflush(rom);

   fputc(newValue, rom);

   member[index].guts = newValue;
}

void SaveState::ChangeMemberLuck(FILE* rom, unsigned char newValue, int index)
{
   // Assumes rom is in write binary mode
   // index can be one of the party members #defined above

   fseek(rom, 0xa5fa + (index * 0x5f), SEEK_SET);
   fflush(rom);

   fputc(newValue, rom);

   member[index].luck = newValue;
}

void SaveState::ChangeMemberVitality(FILE* rom, unsigned char newValue, int index)
{
   // Assumes rom is in write binary mode
   // index can be one of the party members #defined above

   fseek(rom, 0xa5fb + (index * 0x5f), SEEK_SET);
   fflush(rom);

   fputc(newValue, rom);

   member[index].vitality = newValue;
}

void SaveState::ChangeMemberIQ(FILE* rom, unsigned char newValue, int index)
{
   // Assumes rom is in write binary mode
   // index can be one of the party members #defined above

   fseek(rom, 0xa5fc + (index * 0x5f), SEEK_SET);
   fflush(rom);

   fputc(newValue, rom);

   member[index].iq = newValue;
}

void SaveState::ChangeMemberItem(FILE* rom, unsigned char newValue,
                                  int itemIndex, int memberIndex)
{
   // Assumes rom is in write binary mode
   // itemIndex can be from 0 to 13
   // memberIndex can be one of the party members #defined above

   fseek(rom, 0xa604 + (memberIndex * 0x5f) + itemIndex, SEEK_SET);
   fflush(rom);

   fputc(newValue, rom);

   member[memberIndex].item[itemIndex] = newValue;
}

void SaveState::ChangeMemberRollHP(FILE* rom, int newValue, int index)
{
   // Assumes rom is in write binary mode
   // Values for newValue are from 0 to 65535
   // index can be one of the party members #defined above

   fseek(rom, 0xa626 + (index * 0x5f), SEEK_SET);
   fflush(rom);

   fputc(newValue & 255, rom);
   fputc((newValue >> 8) & 255, rom);

   member[index].rollHp = newValue;
}

void SaveState::ChangeMemberHP(FILE* rom, int newValue, int index)
{
   // Assumes rom is in write binary mode
   // Values for newValue are from 0 to 65535
   // index can be one of the party members #defined above

   fseek(rom, 0xa628 + (index * 0x5f), SEEK_SET);
   fflush(rom);

   fputc(newValue & 255, rom);
   fputc((newValue >> 8) & 255, rom);

   member[index].hp = newValue;
}

void SaveState::ChangeMemberRollPP(FILE* rom, int newValue, int index)
{
   // Assumes rom is in write binary mode
   // Values for newValue are from 0 to 65535
   // index can be one of the party members #defined above

   fseek(rom, 0xa62c + (index * 0x5f), SEEK_SET);
   fflush(rom);

   fputc(newValue & 255, rom);
   fputc((newValue >> 8) & 255, rom);

   member[index].rollPp = newValue;
}

void SaveState::ChangeMemberPP(FILE* rom, int newValue, int index)
{
   // Assumes rom is in write binary mode
   // Values for newValue are from 0 to 65535
   // index can be one of the party members #defined above

   fseek(rom, 0xa62e + (index * 0x5f), SEEK_SET);
   fflush(rom);

   fputc(newValue & 255, rom);
   fputc((newValue >> 8) & 255, rom);

   member[index].pp = newValue;
}
