#include <stdio.h>

struct Teleport
{
   void ChangeName(FILE*, char*);
   void ChangeX(FILE*, int);
   void ChangeY(FILE*, int);

   long address;
   char name[25];
   int  x;
   int  y;
};

void PullTeleport(FILE*, Teleport*);


int main(int argc, char* argv[])
{
   FILE*    rom;
   Teleport teleport[16];

   if (argc < 2)
   {
      printf("Usage: pullteleport rom.smc\n");
      return -1;
   }

   rom = fopen(argv[1], "rb+");
   if (!rom)
   {
      printf("Unable to open %s, aborting.\n\n", argv[1]);
      return -1;
   }

   PullTeleport(rom, teleport);
   teleport[0].ChangeX(rom, 12841);
   teleport[0].ChangeY(rom, 198);

   fclose(rom);

   for (int i = 0; i < 16; i++)
   {
      printf("%s\n", teleport[i].name);
      printf("X coord.: %d\n", teleport[i].x);
      printf("Y coord.: %d\n", teleport[i].y);
      printf("Address:  0x%x\n", teleport[i].address);

      printf("\n");
   }

   return 0;
}


void PullTeleport(FILE* rom, Teleport* teleport)
{
   // Assumes rom is in read binary mode
   // psi must already be allocated with at least 16 entries

   char ch;
   int  offset = 0;

   fseek(rom, 0x157a9f, SEEK_SET);

   for (int i = 0; i < 16; i++)
   {
      teleport[i].address = 0x157a9f + offset;

      for (int j = 0; j < 25; j++)
      {
         ch = fgetc(rom);

         if (ch == 0)
            teleport[i].name[j] = 0;
         else
            teleport[i].name[j] = ch - 48;
      }

      ch = fgetc(rom);  // seems to be map # or something???
      ch = fgetc(rom);  // seems to be map # or something???

      teleport[i].x = fgetc(rom);
      teleport[i].x += (fgetc(rom) << 8);
      teleport[i].y = fgetc(rom);
      teleport[i].y += (fgetc(rom) << 8);

      offset += 31;
   }
}


void Teleport::ChangeName(FILE* rom, char* newValue)
{
   // Assumes rom is in write binary mode
   // newValue is 25 characters in length, with the last character being 0.

   fseek(rom, address, SEEK_SET);

   for (int i = 0; i < 25; i++)
   {
      if (newValue[i] == 0)
      {
         fputc(0, rom);
         name[i] = 0;
      }
      else
      {
         fputc(newValue[i] + 48, rom);
         name[i] = newValue[i];
      }
   }
}


void Teleport::ChangeX(FILE* rom, int newValue)
{
   // This function changes the X coordinate of where you will
   // wind up when you teleport.

   // Assumes rom is in write binary form
   // Values allowed are 0 to 65535.  65535 might be insanely too big
   // sometimes, but oh well!

   // The game treats all maps as if they were on one big grid.  Using
   // coordinates, you can choose where you want to go on that big map.

   // For your convenience, coordinates used in the game are included in
   // a file called coords.txt.

   fseek(rom, address + 27, SEEK_SET);
   fflush(rom);

   fputc(newValue & 255, rom);
   fputc((newValue >> 8) & 255, rom);

   x = newValue;
}


void Teleport::ChangeY(FILE* rom, int newValue)
{
   // This function changes the Y coordinate of where you will
   // wind up when you teleport.

   // Assumes rom is in write binary form
   // Values allowed are 0 to 65535.  65535 might be insanely too big
   // sometimes, but that's the user's problem.  Heheh.

   // The game treats all maps as if they were on one big grid.  Using
   // coordinates, you can choose where you want to go on that big map.

   // For your convenience, coordinates used in the game are included in
   // a file called coords.txt.

   fseek(rom, address + 29, SEEK_SET);
   fflush(rom);

   fputc(newValue & 255, rom);
   fputc((newValue >> 8) & 255, rom);

   y = newValue;
}

