#include <stdio.h>
#include <string.h>
#include "storeorder.h"

struct Store
{
   void ChangeItemSold(FILE*, int, int);

   int   itemNum[7];
   int   number;
   int   address;
   char* name;       // This is assigned by us, not the ROM
};

void PullStores(FILE*, Store*);
void SortStoresOriginal(Store*);
void SortStoresGameOrder(Store*);
void SwapStores(Store&, Store&);
void DumpStores(char*, Store*);

void main(void)
{
   FILE* rom;
   Store store[65];

   rom = fopen("ebtest.smc", "rb+");

   PullStores(rom, store);

   SortStoresGameOrder(store);
   SortStoresOriginal(store);

   DumpStores("storedump.txt", store);

   fclose(rom);
}


void PullStores(FILE* rom, Store* store)
{
   // Assumes rom is in read binary mode
   // Assumes store has at least 65 entries allocated already
   // This function fills each entry with the 7 items that are sold
   // at each store.

   fseek(rom, 0x1578b9, SEEK_SET);

   for (int i = 0; i < 65; i++)
   {
      store[i].number = i;
      store[i].address = 0x1578b9 + i * 7;
      store[i].name = storeGameOrderText[i];

      for (int j = 0; j < 7; j++)
         store[i].itemNum[j] = fgetc(rom);
   }
}

void SortStoresGameOrder(Store* store)
{
   // Assumes store is allocated with at least 65 entries.
   // Only entries 0 through 65 will be arranged in the order
   // specified by storeGameOrder[], which is in storeorder.h.

   for (int i = 0; i < 64; i++)
   {
      for (int j = i; j < 65; j++)
      {
         if (store[j].number == storeGameOrder[i])
            SwapStores(store[j], store[i]);
      }
   }
}

void SortStoresOriginal(Store* store)
{
   // Assumes store is allocated with at least 65 entries.
   // Only entries 0 through 65 will be rearranged to their
   // in-ROM order.

   int   biggest;
   int   i;
   int   j;

   for (i = 0; i < 64; i++)
   {
      biggest = i;

      for (j = i; j < 65; j++)
      {
         if (store[biggest].number > store[j].number)
            biggest = j;
      }

      if (biggest != i)
         SwapStores(store[i], store[biggest]);
   }
}

void SwapStores(Store& store1, Store& store2)
{
   // Swaps all the values stored within store1 and store2

   Store temp;

   temp = store1;
   store1 = store2;
   store2 = temp;
}

void DumpStores(char* fileName, Store* store)
{
   // Dumps all the store info to a text file, whose name is specified
   // by fileName.
   // It is assumed store has at least 65 valid entries allocated.
   // Valid meaning that PullStores has been called at least once
   // before.

   FILE* dumpFile;

   dumpFile = fopen(fileName, "w");

   for (int i = 0; i < 65; i++)
   {
      fprintf(dumpFile, "%s\n", store[i].name);

      for (int j = 0; j < 7; j++)
         fprintf(dumpFile, " %d\n", store[i].itemNum[j]);

      fprintf(dumpFile, "\n");
   }

   fclose(dumpFile);
}

void Store::ChangeItemSold(FILE* rom, int slot, int newValue)
{
   // Assumes rom is in write binary mode
   // slot is a value from 0 to 6
   // newValue is the id # of the item to be sold at this slot

   fseek(rom, address + slot, SEEK_SET);
   fflush(rom);

   fputc(newValue, rom);

   itemNum[slot] = newValue;
}

