#include <stdio.h>

struct Psi
{
   void ChangeName(FILE*, char*);

   long address;
   char name[25];
};

void PullPsi(FILE*, Psi*);


int main(int argc, char* argv[])
{
   FILE* rom;
   Psi   psi[16];

   if (argc < 2)
   {
      printf("Usage: pullpsi rom.smc\n");
      return -1;
   }

   rom = fopen(argv[1], "rb+");
   if (!rom)
   {
      printf("Unable to open %s, aborting.\n\n", argv[1]);
      return -1;
   }

   PullPsi(rom, psi);

   fclose(rom);

   for (int i = 0; i < 16; i++)
   {
      printf("%s\n", psi[i].name);
      printf("Address: 0x%x\n", psi[i].address);

      printf("\n");
   }

   return 0;
}


void PullPsi(FILE* rom, Psi* psi)
{
   // Assumes rom is in read binary mode
   // psi must already be allocated with at least 16 entries

   char ch;
   int  offset = 0;

   fseek(rom, 0x158f93, SEEK_SET);

   for (int i = 0; i < 16; i++)
   {
      psi[i].address = 0x158f93 + offset;

      for (int j = 0; j < 25; j++)
      {
         ch = fgetc(rom);

         if (ch == 0)
            psi[i].name[j] = 0;
         else
            psi[i].name[j] = ch - 48;
      }

      offset += 25;
   }
}


void Psi::ChangeName(FILE* rom, char* newValue)
{
   // Assumes rom is in write binary mode
   // newValue is 25 characters in length, with the last character being 0.

   fseek(rom, address, SEEK_SET);

   for (int i = 0; i < 25; i++)
   {
      if (newValue[i] == 0)
      {
         fputc(0, rom);
         name[i] = 0;
      }
      else
      {
         fputc(newValue[i] + 48, rom);
         name[i] = newValue[i];
      }
   }
}
