#include <stdio.h>

struct Phone
{
   void ChangeName(FILE*, char*);
   void ChangePointer(FILE*, unsigned int);

   long         address;
   char         name[25];
   unsigned int pointer;
};

void PullPhone(FILE*, Phone*);


int main(int argc, char* argv[])
{
   FILE* rom;
   Phone phone[5];

   if (argc < 2)
   {
      printf("Usage: pullphone rom.smc\n");
      return -1;
   }

   rom = fopen(argv[1], "rb+");
   if (!rom)
   {
      printf("Unable to open %s, aborting.\n\n", argv[1]);
      return -1;
   }

   PullPhone(rom, phone);

   fclose(rom);

   for (int i = 0; i < 5; i++)
   {
      printf("%s\n", phone[i].name);
      printf("Pointer: 0x%x\n", phone[i].pointer);
      printf("Address: 0x%x\n", phone[i].address);

      printf("\n");
   }

   return 0;
}


void PullPhone(FILE* rom, Phone* phone)
{
   // Assumes rom is in read binary mode
   // phone must already be allocated with at least 5 entries

   char ch;
   int  offset = 0;

   fseek(rom, 0x157cae, SEEK_SET);

   for (int i = 0; i < 5; i++)
   {
      phone[i].address = 0x157cae + offset;

      for (int j = 0; j < 25; j++)
      {
         ch = fgetc(rom);

         if (ch == 0)
            phone[i].name[j] = 0;
         else
            phone[i].name[j] = ch - 48;
      }

      ch = fgetc(rom);
      ch = fgetc(rom);

      phone[i].pointer = fgetc(rom);
      phone[i].pointer += (fgetc(rom) << 8);
      phone[i].pointer += (fgetc(rom) << 16);
      phone[i].pointer += (fgetc(rom) << 24);

      offset += 31;
   }
}


void Phone::ChangeName(FILE* rom, char* newValue)
{
   // Assumes rom is in write binary mode
   // newValue is 25 characters in length, with the last character being 0.

   fseek(rom, address, SEEK_SET);

   for (int i = 0; i < 25; i++)
   {
      if (newValue[i] == 0)
      {
         fputc(0, rom);
         name[i] = 0;
      }
      else
      {
         fputc(newValue[i] + 48, rom);
         name[i] = newValue[i];
      }
   }
}


void Phone::ChangePointer(FILE* rom, unsigned int newValue)
{
   // I'm not exactly sure yet, but it appears that the text used when you make a phone
   // call is somehow chosen using a 4-byte block.  It might actually just be 2 bytes,
   // but if it is, then I have no idea what the remaining upper 2 bytes are for.
   // People should play around with this and give me info they find, cuz trying to
   // figure out how EB's text addressing system works is insanely difficult.

   // For people interested, the "pointers" used by EB for the phone calls
   // are listed in phone.txt.  It's my belief that almost all text
   // references use the same method used here, now just to figure it out.
   // If I could, I could easily make a better text dump, and make a text
   // editor for PK Hack.

   // Assumes rom is in write binary mode
   // Assumes newValue is from 0 to 2^32 (which is like 4 billion and something)

   fseek(rom, address + 27, SEEK_SET);
   fflush(rom);

   fputc(newValue & 255, rom);
   fputc((newValue >> 8) & 255, rom);
   fputc((newValue >> 16) & 255, rom);
   fputc((newValue >> 24) & 255, rom);

   pointer = newValue;
}
