#include <stdio.h>

void PullPalettes(FILE*);

int main(int argc, char* argv[])
{
   FILE* rom;

   if (argc < 2)
   {
      printf("Usage: pullpalettes rom.smc\n");
      return -1;
   }

   rom = fopen(argv[1], "rb");
   if (!rom)
   {
      printf("Error opening %s!\n", argv[1]);
      return -1;
   }

   PullPalettes(rom);

   fclose(rom);

   return 0;
}

void PullPalettes(FILE* rom)
{
   int           bgrBlock;
   unsigned char r;
   unsigned char g;
   unsigned char b;
   unsigned char ch;
   unsigned char ch2;

   fseek(rom, 0x30200, SEEK_SET);
//   fseek(rom, 0x302a0, SEEK_SET);



   for (int j = 0; j < 16; j++)
   {
      printf("----%d----\n", j);
   for (int i = 0; i < 16; i++)
   {
      ch = fgetc(rom);
      ch2 = fgetc(rom);

      bgrBlock = ch2 << 8;
      bgrBlock += ch;
      bgrBlock &= 0x7FFF;

      b = bgrBlock >> 10;
      g = (bgrBlock & 0x03e0) >> 5;
      r = bgrBlock & 0x001f;

      printf("%d %d %d\n", r * 2, g * 2, b * 2);
   }

   printf("\n");
   }
}
