// NOTE: The EarthBound fonts only have 112 characters each.

#include <stdio.h>
#include <string.h>
#include <allegro.h>

void PullMainFont(FILE*, int, int[16][16], int&);
void PullSaturnFont(FILE*, int, int[16][16], int&);
void PullBattleFont(FILE*, int, int[16][16], int&);
void PullTinyFont(FILE*, int, int[16][16], int&);
void PullBigFont(FILE*, int, int[16][16], int&);
void ChangeMainFont(FILE*, char, int[16][16], unsigned char);
void ChangeSaturnFont(FILE*, char, int[16][16], unsigned char);
void ChangeBattleFont(FILE*, char, int[16][16], unsigned char);
void ChangeTinyFont(FILE*, char, int[16][16], unsigned char);
void ChangeBigFont(FILE*, char, int[16][16], unsigned char);
void ClearOut(int[16][16]);

void WriteParagraph(FILE*, char*, int, int[16][16]);
void DrawFont(int[16][16], int, int);


int main(int argc, char* argv[])
{
   FILE* rom;
   int   fontPic[16][16];
   RGB   col;
   int   kee = 9;
   int   num = 0;
   int   lastNum = 0;
   int   width;
   char  funString[256];
   /* =
"@My Secret Life, chapter three. (Story from the previous chapter.)\n
@I was neither a murder suspect,\n
@nor a target for an international spy organization.\n
@But I drove a car down the Jersey Turnpike at 80 mph.\n
@...A police officer pulled me over and asked for my driver's license.\n
@He said I was going 20 mph over the speed limit.\n
@I instantly pointed to my wife and said I'm in a hurry, my wife is in labor.\n
@Fortunately, my wife actually had a big stomach.\n
@I hoped he'd let me go with this excuse.\n
@Oh, since it's an emergency.\n
@I'll lead you to the hospital with my police car, he said.\n
@No, it's not necessary.\n
 Why not? asked the officer.\n
@Uh... well...\n
 Let's get going, said the officer...\n
@No, no!  We can't!  This baby is a demon child!";*/


   if (argc < 2)
   {
      printf("Usage: pullfonts rom.smc\n");
      return -1;
   }

   rom = fopen(argv[1], "rb+");
   if (!rom)
   {
      printf("Error opening %s!\n", argv[1]);
      return -1;
   }

   gets(funString);

   allegro_init();
   install_keyboard();
   set_color_depth(8);
   set_gfx_mode(GFX_VGA, 320, 200, 0, 0);

   col.r = col.b = col.g = 63;
   set_color(1, &col);
/*
   PullTinyFont(rom, 'Z' - 32, fontPic, width);
   ChangeMainFont(rom, 'Z' - 32, fontPic, width);
   ChangeSaturnFont(rom, 'Z' - 32, fontPic, width);
   ChangeBattleFont(rom, 'Z' - 32, fontPic, width);
   ChangeBigFont(rom, 'Z' - 32, fontPic, width);*/

   for (int y = 0; y < 6; y++)
   {
      for (int x = 0; x < 16; x++)
      {
         PullMainFont(rom, y * 16 + x, fontPic, width);
         DrawFont(fontPic, x * 16, y * 16);
      }
   }

   for (int y = 0; y < 6; y++)
   {
      for (int x = 0; x < 16; x++)
      {
         PullSaturnFont(rom, y * 16 + x, fontPic, width);
         DrawFont(fontPic, x * 16, 96 + y * 16);
      }
   }


   while (kee != KEY_ESC)
   {
      kee = readkey() >> 8;

      if (kee == KEY_LEFT)
      {
         num--;
         if (num < 0)
            num = 0;
      }
      else if (kee == KEY_RIGHT)
      {
         num++;
         if (num > 7)
            num = 7;
      }

      if (lastNum != num)
      {
         clear(screen);

         switch (num)
         {
            case 0:
            {
               for (int y = 0; y < 6; y++)
               {
                  for (int x = 0; x < 16; x++)
                  {
                     PullMainFont(rom, y * 16 + x, fontPic, width);
                     DrawFont(fontPic, x * 16, y * 16);
                  }
               }

               for (int y = 0; y < 6; y++)
               {
                  for (int x = 0; x < 16; x++)
                  {
                     PullSaturnFont(rom, y * 16 + x, fontPic, width);
                     DrawFont(fontPic, x * 16, 96 + y * 16);
                  }
               }

               break;
            }

            case 1:
            {
               for (int y = 0; y < 6; y++)
               {
                  for (int x = 0; x < 16; x++)
                  {
                     ClearOut(fontPic);
                     PullBattleFont(rom, y * 16 + x, fontPic, width);
                     DrawFont(fontPic, x * 16, y * 16);
                  }
               }

               for (int y = 0; y < 6; y++)
               {
                  for (int x = 0; x < 16; x++)
                  {
                     ClearOut(fontPic);
                     PullTinyFont(rom, y * 16 + x, fontPic, width);
                     DrawFont(fontPic, x * 16, 96 + y * 16);
                  }
               }

               break;
            }

            case 2:
            {
               for (int y = 0; y < 6; y++)
               {
                  for (int x = 0; x < 16; x++)
                  {
                     PullBigFont(rom, y * 16 + x, fontPic, width);
                     DrawFont(fontPic, x * 16, y * 16);
                  }
               }

               break;
            }

            case 3:
            {
               WriteParagraph(rom, funString, 0, fontPic);
               break;
            }

            case 4:
            {
               WriteParagraph(rom, funString, 1, fontPic);
               break;
            }

            case 5:
            {
               WriteParagraph(rom, funString, 2, fontPic);
               break;
            }

            case 6:
            {
               WriteParagraph(rom, funString, 3, fontPic);
               break;
            }

            case 7:
            {
               WriteParagraph(rom, funString, 4, fontPic);
               break;
            }
         }
      }

      lastNum = num;
   }

   fclose(rom);

   return 0;
}

void PullMainFont(FILE* rom, int charNum, int fontPic[16][16], int& width)
{
   // Assumes rom is in read binary mode.
   // Retrieves one character of the main text's font, which is specified
   // by charNum.  You need to take the ASCII value of the character you
   // want to edit and subtract 32 from it before calling this function.
   // width is the width of the character as it is stored in the ROM.
   // It can range from 0 to 255.  If it's over 16, that means there's
   // blank space that will be added to the end when it is displayed in
   // the game.
   // The maximum size for characters using this font is 16 wide by 16 high.

   unsigned char ch;

   ClearOut(fontPic);

   fseek(rom, 0x210e7a + charNum, SEEK_SET);
   width = fgetc(rom);

   fseek(rom, 0x210eda + 32 * charNum, SEEK_SET);

   for (int i = 0; i < 16; i++)
   {
      ch = ~fgetc(rom);

      for (int x = 0; x < 8; x++)
         fontPic[i][7 - x] = (ch & (1 << x)) >> x;
   }

   for (int i = 0; i < 16; i++)
   {
      ch = ~fgetc(rom);

      for (int x = 0; x < 8; x++)
         fontPic[i][15 - x] = (ch & (1 << x)) >> x;
   }
}

void PullSaturnFont(FILE* rom, int charNum, int fontPic[16][16], int& width)
{
   // Assumes rom is in read binary mode.
   // Retrieves one character of the mr. saturn font, which is specified
   // by charNum.  You need to take the ASCII value of the character you
   // want to edit and subtract 32 from it before calling this function.
   // width is the width of the character as it is stored in the ROM.
   // It can range from 0 to 255.  If it's over 16, that means there's
   // blank space that will be added to the end when it is displayed in
   // the game.
   // The maximum size for characters using this font is 16 wide by 16 high.

   unsigned char ch;

   ClearOut(fontPic);

   fseek(rom, 0x201559 + charNum, SEEK_SET);
   width = fgetc(rom);

   fseek(rom, 0x2015b9 + 32 * charNum, SEEK_SET);

   for (int i = 0; i < 16; i++)
   {
      ch = ~fgetc(rom);

      for (int x = 0; x < 8; x++)
         fontPic[i][7 - x] = (ch & (1 << x)) >> x;
   }

   for (int i = 0; i < 16; i++)
   {
      ch = ~fgetc(rom);

      for (int x = 0; x < 8; x++)
         fontPic[i][15 - x] = (ch & (1 << x)) >> x;
   }
}

void PullBattleFont(FILE* rom, int charNum, int fontPic[16][16], int& width)
{
   // Retrieves rom is in read binary mode.
   // Changes one character of the battle font, which is specified
   // by charNum.  You need to take the ASCII value of the character you
   // want to edit and subtract 32 from it before calling this function.
   // width is the width of the character as it is stored in the ROM.
   // It can range from 0 to 255.  If it's over 8, that means there's
   // blank space that will be added to the end when it is displayed in
   // the game.
   // The maximum size for characters using this font is 8 wide by 16 high.

   unsigned char ch;

   ClearOut(fontPic);

   fseek(rom, 0x211ada + charNum, SEEK_SET);
   width = fgetc(rom);

   fseek(rom, 0x211b3a + 16 * charNum, SEEK_SET);

   for (int i = 0; i < 16; i++)
   {
      ch = ~fgetc(rom);

      for (int x = 0; x < 8; x++)
         fontPic[i][7 - x] = (ch & (1 << x)) >> x;
   }
}

void PullTinyFont(FILE* rom, int charNum, int fontPic[16][16], int& width)
{
   // Retrieves rom is in read binary mode.
   // Changes one character of the tiny font, which is specified
   // by charNum.  You need to take the ASCII value of the character you
   // want to edit and subtract 32 from it before calling this function.
   // width is the width of the character as it is stored in the ROM.
   // It can range from 0 to 255.  If it's over 8, that means there's
   // blank space that will be added to the end when it is displayed in
   // the game.
   // The maximum size for characters using this font is 8 wide by 8 high.

   unsigned char ch;

   ClearOut(fontPic);

   fseek(rom, 0x21213a + charNum, SEEK_SET);
   width = fgetc(rom);

   fseek(rom, 0x21219a + 8 * charNum, SEEK_SET);

   for (int i = 0; i < 8; i++)
   {
      ch = ~fgetc(rom);

      for (int x = 0; x < 8; x++)
         fontPic[i][7 - x] = (ch & (1 << x)) >> x;
   }
}

void PullBigFont(FILE* rom, int charNum, int fontPic[16][16], int& width)
{
   // Retrieves rom is in read binary mode.
   // Changes one character of the big font, which is specified
   // by charNum.  You need to take the ASCII value of the character you
   // want to edit and subtract 32 from it before calling this function.
   // width is the width of the character as it is stored in the ROM.
   // It can range from 0 to 255.  If it's over 16, that means there's
   // blank space that will be added to the end when it is displayed in
   // the game.
   // The maximum size for characters using this font is 16 wide by 16 high.

   unsigned char ch;

   ClearOut(fontPic);

   fseek(rom, 0x21249a + charNum, SEEK_SET);
   width = fgetc(rom);

   fseek(rom, 0x2124fa + 32 * charNum, SEEK_SET);

   for (int i = 0; i < 16; i++)
   {
      ch = ~fgetc(rom);

      for (int x = 0; x < 8; x++)
         fontPic[i][7 - x] = (ch & (1 << x)) >> x;
   }

   for (int i = 0; i < 16; i++)
   {
      ch = ~fgetc(rom);

      for (int x = 0; x < 8; x++)
         fontPic[i][15 - x] = (ch & (1 << x)) >> x;
   }
}

void ChangeMainFont(FILE* rom, char charNum, int newFont[16][16], unsigned char width)
{
   // Assumes rom is in write binary mode.
   // Changes one character of the main text's font, which is specified
   // by charNum.  You need to take the ASCII value of the character you
   // want to edit and subtract 32 from it before calling this function.
   // width is the width of the character.
   // It can range from 0 to 255.  If it's over 16, that means there's
   // blank space that will be added to the end when it is displayed in
   // the game.
   // The maximum size for characters using this font is 16 wide by 16 high.

   unsigned char temp;
   char          ch;

   fseek(rom, 0x210e7a + charNum, SEEK_SET);
   fflush(rom);
   fputc(width, rom);

   fseek(rom, 0x210eda + 32 * charNum, SEEK_SET);
   fflush(rom);

   for (int y = 0; y < 16; y++)
   {
      temp = 0;

      for (int x = 0; x < 8; x++)
      {
         temp |= newFont[y][x] << (7 - x);
      }

      fputc(~temp, rom);
   }

   for (int y = 0; y < 16; y++)
   {
      temp = 0;

      for (int x = 0; x < 8; x++)
      {
         temp |= newFont[y][x + 8]  << (7 - x);
      }

      fputc(~temp, rom);
   }
}

void ChangeSaturnFont(FILE* rom, char charNum, int newFont[16][16], unsigned char width)
{
   // Assumes rom is in write binary mode.
   // Changes one character of the mr. saturn font, which is specified
   // by charNum.  You need to take the ASCII value of the character you
   // want to edit and subtract 32 from it before calling this function.
   // width is the width of the character.
   // It can range from 0 to 255.  If it's over 16, that means there's
   // blank space that will be added to the end when it is displayed in
   // the game.
   // The maximum size for characters using this font is 16 wide by 16 high.

   unsigned char temp;
   char          ch;

   fseek(rom, 0x201559 + charNum, SEEK_SET);
   fflush(rom);
   fputc(width, rom);

   fseek(rom, 0x2015b9 + 32 * charNum, SEEK_SET);
   fflush(rom);

   for (int y = 0; y < 16; y++)
   {
      temp = 0;

      for (int x = 0; x < 8; x++)
      {
         temp |= newFont[y][x]  << (7 - x);
      }

      fputc(~temp, rom);
   }

   for (int y = 0; y < 16; y++)
   {
      temp = 0;

      for (int x = 0; x < 8; x++)
      {
         temp |= newFont[y][x + 8]  << (7 - x);
      }

      fputc(~temp, rom);
   }
}

void ChangeBattleFont(FILE* rom, char charNum, int newFont[16][16], unsigned char width)
{
   // Assumes rom is in write binary mode.
   // Changes one character of the battle font, which is specified
   // by charNum.  You need to take the ASCII value of the character you
   // want to edit and subtract 32 from it before calling this function.
   // width is the width of the character.
   // It can range from 0 to 255.  If it's over 8, that means there's
   // blank space that will be added to the end when it is displayed in
   // the game.
   // The maximum size for characters using this font is 8 wide by 16 high.

   unsigned char temp;
   char          ch;

   fseek(rom, 0x211ada + charNum, SEEK_SET);
   fflush(rom);
   fputc(width, rom);

   fseek(rom, 0x211b3a + 16 * charNum, SEEK_SET);
   fflush(rom);

   for (int y = 0; y < 16; y++)
   {
      temp = 0;

      for (int x = 0; x < 8; x++)
      {
         temp |= newFont[y][x]  << (7 - x);
      }

      fputc(~temp, rom);
   }
}

void ChangeTinyFont(FILE* rom, char charNum, int newFont[16][16], unsigned char width)
{
   // Assumes rom is in write binary mode.
   // Changes one character of the tiny font, which is specified
   // by charNum.  You need to take the ASCII value of the character you
   // want to edit and subtract 32 from it before calling this function.
   // width is the width of the character.
   // It can range from 0 to 255.  If it's over 8, that means there's
   // blank space that will be added to the end when it is displayed in
   // the game.
   // The maximum size for characters using this font is 8 wide by 8 high.

   unsigned char temp;
   char          ch;

   fseek(rom, 0x21213a + charNum, SEEK_SET);
   fflush(rom);
   fputc(width, rom);

   fseek(rom, 0x21219a + 8 * charNum, SEEK_SET);
   fflush(rom);

   for (int y = 0; y < 8; y++)
   {
      temp = 0;

      for (int x = 0; x < 8; x++)
      {
         temp |= newFont[y][x]  << (7 - x);
      }

      fputc(~temp, rom);
   }
}

void ChangeBigFont(FILE* rom, char charNum, int newFont[16][16], unsigned char width)
{
   // Assumes rom is in write binary mode.
   // Changes one character of the big font, which is specified
   // by charNum.  You need to take the ASCII value of the character you
   // want to edit and subtract 32 from it before calling this function.
   // width is the width of the character.
   // It can range from 0 to 255.  If it's over 16, that means there's
   // blank space that will be added to the end when it is displayed in
   // the game.
   // The maximum size for characters using this font is 16 wide by 16 high.

   unsigned char temp;
   char          ch;

   fseek(rom, 0x21249a + charNum, SEEK_SET);

   fflush(rom);
   fputc(width, rom);

   fseek(rom, 0x2124fa + 32 * charNum, SEEK_SET);
   fflush(rom);

   for (int y = 0; y < 16; y++)
   {
      temp = 0;

      for (int x = 0; x < 8; x++)
      {
         temp |= newFont[y][x] << (7 - x);
      }

      fputc(~temp, rom);
   }

   for (int y = 0; y < 16; y++)
   {
      temp = 0;

      for (int x = 0; x < 8; x++)
      {
         temp |= newFont[y][x + 8]  << (7 - x);
      }

      fputc(~temp, rom);
   }
}

void ClearOut(int array[16][16])
{
   // This is used internally to make sure that fonts don't contain garbage
   // in them.

   for (int iy = 0; iy < 16; iy++)
   {
      for (int ix = 0; ix < 16; ix++)
      {
         array[iy][ix] = 0;
      }
   }
}


void DrawFont(int fontPic[16][16], int xx, int yy)
{
   for (int y = 0; y < 16; y++)
   {
      for (int x = 0; x < 16; x++)
      {
         if (fontPic[y][x] == 1)
            putpixel(screen, xx + x, yy + y, 1);
      }
   }
}

void WriteParagraph(FILE* rom, char* str, int fontType, int fontPic[16][16])
{
   char ch;
   int  curX = 0;
   int  curY = 0;
   int  index = 0;
   int  width;
   int  height;

   if (fontType == 0)
      height = 12;
   if (fontType == 1)
      height = 16;
   if (fontType == 2)
      height = 8;
   if (fontType == 3)
      height = 8;
   if (fontType == 4)
      height = 16;

   ch = str[index];

   while (ch != '\0')
   {
      if (ch == '\n')
      {
         curX = 0;
         curY += height;
         index++;
      }
      else
      {
         if (fontType == 0)
            PullMainFont(rom, ch - 32, fontPic, width);
         else if (fontType == 1)
            PullSaturnFont(rom, ch - 32, fontPic, width);
         else if (fontType == 2)
            PullBattleFont(rom, ch - 32, fontPic, width);
         else if (fontType == 3)
            PullTinyFont(rom, ch - 32, fontPic, width);
         else if (fontType == 4)
            PullBigFont(rom, ch - 32, fontPic, width);

         if (curX + width > 319)
         {
            curX = 0;
            curY += height;

            DrawFont(fontPic, curX, curY);

            curX += width + 1;
         }
         else
         {
            DrawFont(fontPic, curX, curY);

            curX += width + 1;
         }
      }

      ch = str[++index];
   }
}
