#include <stdio.h>

struct BattleMenu
{
   void ChangeName(FILE*, char*);

   long address;
   char name[16];
};

void PullBattleMenu(FILE*, BattleMenu*);


int main(int argc, char* argv[])
{
   FILE*      rom;
   BattleMenu bmEntry[11];

   if (argc < 2)
   {
      printf("Usage: pullbmenu rom.smc\n");
      return -1;
   }

   rom = fopen(argv[1], "rb+");
   if (!rom)
   {
      printf("Unable to open %s, aborting.\n\n", argv[1]);
      return -1;
   }

   PullBattleMenu(rom, bmEntry);

   fclose(rom);

   for (int i = 0; i < 11; i++)
   {
      printf("%s\n", bmEntry[i].name);
      printf("Address: 0x%x\n", bmEntry[i].address);

      printf("\n");
   }

   return 0;
}


void PullBattleMenu(FILE* rom, BattleMenu* bmEntry)
{
   // Assumes rom is in read binary mode
   // bmEntry must already be allocated with at least 11 entries

   char ch;
   int  offset = 0;

   fseek(rom, 0x04a1e1, SEEK_SET);

   for (int i = 0; i < 11; i++)
   {
      bmEntry[i].address = 0x04a1e1 + offset;

      for (int j = 0; j < 16; j++)
      {
         ch = fgetc(rom);

         if (ch == 0)
            bmEntry[i].name[j] = 0;
         else
            bmEntry[i].name[j] = ch - 48;
      }

      offset += 16;
   }
}


void BattleMenu::ChangeName(FILE* rom, char* newValue)
{
   // Assumes rom is in write binary mode
   // newValue is 16 characters in length, with the last character being 0.

   fseek(rom, address, SEEK_SET);

   for (int i = 0; i < 16; i++)
   {
      if (newValue[i] == 0)
      {
         fputc(0, rom);
         name[i] = 0;
      }
      else
      {
         fputc(newValue[i] + 48, rom);
         name[i] = newValue[i];
      }
   }
}
