#include <stdio.h>

struct Ailment
{
   void ChangeName(FILE*, char*);

   long address;
   char name[16];
};

void PullAilments(FILE*, Ailment*);


int main(int argc, char* argv[])
{
   FILE*   rom;
   Ailment ailment[10];

   if (argc < 2)
   {
      printf("Usage: pullailment rom.smc\n");
      return -1;
   }

   rom = fopen(argv[1], "rb+");
   if (!rom)
   {
      printf("Unable to open %s, aborting.\n\n", argv[1]);
      return -1;
   }

   PullAilments(rom, ailment);

   fclose(rom);

   for (int i = 0; i < 10; i++)
   {
      printf("%s\n", ailment[i].name);
      printf("Address: 0x%x\n", ailment[i].address);

      printf("\n");
   }

   return 0;
}


void PullAilments(FILE* rom, Ailment* ailment)
{
   // Assumes rom is in read binary mode
   // ailment must already be allocated with at least 10 entries

   char ch;
   int  offset = 0;

   fseek(rom, 0x045d70, SEEK_SET);

   for (int i = 0; i < 10; i++)
   {
      ailment[i].address = 0x045d70 + offset;

      for (int j = 0; j < 16; j++)
      {
         ch = fgetc(rom);

         if (ch == 0)
            ailment[i].name[j] = 0;
         else
            ailment[i].name[j] = ch - 48;
      }

      offset += 16;
   }
}


void Ailment::ChangeName(FILE* rom, char* newValue)
{
   // Assumes rom is in write binary mode
   // newValue is 16 characters in length, with the last character being 0.

   fseek(rom, address, SEEK_SET);

   for (int i = 0; i < 16; i++)
   {
      if (newValue[i] == 0)
      {
         fputc(0, rom);
         name[i] = 0;
      }
      else
      {
         fputc(newValue[i] + 48, rom);
         name[i] = newValue[i];
      }
   }
}
