#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

void          LoadCompressedText(FILE*);
void          LoadTextPointers(FILE*);
int           GetType(unsigned char ch);
void          GetStringAt(FILE*, unsigned int, char[], int&);
unsigned int  GetTextPointer(FILE*, int);
unsigned int  HexToSNES(unsigned int);
unsigned int  SNESToHex(unsigned int);
void          WriteText(FILE*, unsigned int, char*, int&);
int           ExpandROM(FILE*, unsigned int);
int           GetNumbers(char*, int[256]);
int           CharToHex(char);

void PrintMainMenu(void);
void LoadROM(FILE*);
void CloseROM(FILE*);
void DisplayText(FILE*);
void ChangeText(FILE*);

unsigned int textPtrAddress[5000];
char         comprText[768][25];
char         filename[128] = "ebtest.smc";
int          textPtrCount;
FILE*        rom;
int          romLoaded = 0;

int main(int argc, char* argv[])
{
   FILE*        inputFile;
   char         str[14096];
   unsigned int tpAddr;
   unsigned int ptrAddr;
   int          listNum;
   int          size;
   int          choice = 0;

//   rom = fopen(filename, "rb+");
//   LoadCompressedText(rom);

//   tpAddr = 0x51d12;

/*   for (int i = 0; i < 5500; i++)
   {
      GetStringAt(rom, tpAddr, str, size);
      printf("0x%x 0x%x %s\n", tpAddr, HexToSNES(tpAddr), str);
      
      tpAddr += size;
   }*/

   PrintMainMenu();
   scanf("%d", &choice);

   while (choice != 5)
   {
      switch (choice)
      {
         case 1:
         {
            LoadROM(rom);
            break;
         }
         case 2:
         {
            CloseROM(rom);
            break;
         }
         case 3:
         {
            DisplayText(rom);
            break;
         }
         case 4:
         {
            ChangeText(rom);
            break;
         }
      }

      PrintMainMenu();
      scanf("%d", &choice);
   }



   fclose(rom);
}

void LoadCompressedText(FILE* rom)
{
   // Loads the look-up table into the comprText list of strings.
   // Assumes rom is in read binary mode.

   unsigned char ch;
   char          strLoc;

   comprText[0][0] = 0;

   fseek(rom, 0x8be3e, SEEK_SET);

   for (int i = 1; i < 768; i++)
   {
      strLoc = 0;
      ch = 255;

      while (ch != 0)
      {
         ch = fgetc(rom);

         if (ch != 0)
            comprText[i][strLoc] = ch - 0x30;
         else
            comprText[i][strLoc] = 0;

         strLoc++;
      }
   }
}

void LoadTextPointers(FILE* rom)
{
   unsigned char ch;
   unsigned int  loc = 0x50200;

   textPtrCount = 0;

   fseek(rom, loc, SEEK_SET);

   while (loc < 0x51d12)
   {
      ch = fgetc(rom);
      ch = fgetc(rom);
      loc += 2;

      if (ch == 6)
      {
         ch = fgetc(rom);
         ch = fgetc(rom);
         ch = fgetc(rom);
         ch = fgetc(rom);
         ch = fgetc(rom);
         textPtrAddress[textPtrCount++] = loc - 2;

         loc += 5;
      }
   }
}

int GetType(unsigned char ch)
{
   // Returns the type of character ch represents in the text
   // stream.
   // Type 0:  A regular piece of text.
   // Type 1:  Means you'll need to use the lookup table
   // Type 2:  A control code

   char retVal = 2;

   if ((ch >= 0x50) && (ch <= 0xAA))
      retVal = 0;
   else if ((ch >= 0x15) && (ch <= 0x17))
      retVal = 1;

   return retVal;
}

void GetStringAt(FILE* rom, unsigned int address, char string[14096], int& size)
{
   // Gets the string located at the specified hex address.
   // Assumes rom is in read binary mode.

   unsigned char ch = 255;
   unsigned char ch2;
   char          tempStr[25];
   int           charType;
   int           strPos = 0;
   int           cNum;
   int           cLen;
   int           i;
   int           opCodeOn = 0;

   fseek(rom, address, SEEK_SET);

   for (i = 0; i < 14096; i++)
      string[i] = 0;

   size = 0;

   while (ch != 2)
   {
      ch = fgetc(rom);
      charType = GetType(ch);

      if ((charType != 2) && (opCodeOn == 1))
      {
         string[strPos++] = ']';
         opCodeOn = 0;
      }

      switch (charType)
      {
         case 0:
         {
            string[strPos++] = ch - 48;
            size++;
            break;
         }
         case 1:
         {
            ch2 = fgetc(rom);

            cNum = (ch - 0x15) * 256 + ch2;
            cLen = strlen(comprText[cNum]);

            for (int i = 0; i < cLen; i++)
            {
               string[strPos++] = comprText[cNum][i];
            }

            size += 2;

            break;
         }
         case 2:
         {
            size++;

            if (opCodeOn == 0)
            {
               sprintf(tempStr, "[%.2X", ch);
               strcat(string, tempStr);
               strPos += strlen(tempStr);
               opCodeOn = 1;
            }
            else
            {
               sprintf(tempStr, " %.2X", ch);
               strcat(string, tempStr);
               strPos += strlen(tempStr);
            }

            if ((ch == 0x1C) || (ch == 0x08))
            {
               ch = fgetc(rom);
               ch2 = fgetc(rom);

               sprintf(tempStr, " %.2X %.2X", ch, ch2);
               strcat(string, tempStr);
               strPos += strlen(tempStr);
               size += 2;

               ch = 0;
            }
            else if ((ch == 0x19) || (ch == 0x04) || (ch == 0x05)
                  || (ch == 0x1F))
            {
               ch = fgetc(rom);

               sprintf(tempStr, " %.2X", ch);
               strcat(string, tempStr);
               strPos += strlen(tempStr);
               size++;

               ch = 0;
            }

            break;
         }
      }
   }

   if (opCodeOn == 1)
   {
      string[strPos++] = ']';
   }
}

unsigned int GetTextPointer(FILE* rom, int pointerNum)
{
   // Gets the appropriate text pointer from the text pointer tables
   // in the ROM.  pointerNum is just an index into those tables.
   // Assumes rom is in read binary mode.  This returns an SNES
   // address.

   unsigned char ch;
   unsigned int  loc;

   fseek(rom, textPtrAddress[pointerNum], SEEK_SET);

   ch = fgetc(rom);
   ch = fgetc(rom);
   ch = fgetc(rom);
   ch = fgetc(rom);

   loc = fgetc(rom);
   loc += (fgetc(rom) << 8);
   loc += (fgetc(rom) << 16);

   return loc;
}

unsigned int HexToSNES(unsigned int address)
{
   // Converts good-ol regular hex addresses into the SNES-style addresses.
   // In this case, it's assumed the ROM is a hi-rom with a header.

   unsigned int retVal;

   retVal = (address + 0xc00000) - 0x200;

   return retVal;
}

unsigned int SNESToHex(unsigned int address)
{
   // Converts an SNES-style address (hi-rom, with header) to a nice
   // handy hex address.

   unsigned int retVal;

   retVal = (address - 0xc00000) + 0x200;

   return retVal;
}

void WriteText(FILE* rom, unsigned int address, char* string, int& size)
{
   char tempStr[1024];
   int  number[256];
   int  strPos = 0;
   int  tempPos;
   int  strLen;
   int  total;
   char ch;

   size = 0;

   fseek(rom, address, SEEK_SET);

   strLen = strlen(string);

   while (strPos < strLen)
   {
      ch = string[strPos];

      if (ch == '[')
      {
         tempPos = 0;
         while (ch != ']')
         {
            tempStr[tempPos++] = ch;
            ch = string[++strPos];
         }

         tempStr[tempPos] = ']';
         tempStr[tempPos + 1] = '\0';

         total = GetNumbers(tempStr, number);
         size += total;

         for (int i = 0; i < total; i++)
            fputc(number[i], rom);
      }
      else
      {
         fputc(string[strPos] + 0x30, rom);
         size++;
      }

      strPos++;
   }
}

int ExpandROM(FILE* rom, unsigned int size)
{
   // Expands the rom to the given filesize.  Sort of assumes the
   // file has the file name given in the global string filename.
   // Returns 1 on success, 0 on failure.
   // 0x4001FF is the maximum size that is probably good; the text
   // addressing system can't access anything past of that.
   // That gives people about 1 extra meg to use for fun fun
   // text fun!

   long fileSize;
   int  retVal = 0;

   fseek(rom, 0, SEEK_END);
   fileSize = ftell(rom);

   if (fileSize < size)
   {
      fclose(rom);
      fopen(filename, "ab");

      for (int i = fileSize; i < size; i++)
         fputc(0, rom);

      fclose(rom);

      fopen(filename, "rb+");
      retVal = 1;
   }

   return retVal;
}

int GetNumbers(char* string, int number[256])
{
   // Assumes the string is not empty (0 size).
   // Assumes that string begins with '[' and ends with ']'.
   // Returns -1 if there's an error.
   // Assumes that all the numbers within are written in hex,
   // and are all valid hex numbers.

   int  strPos = 0;
   int  numPos = -1;
   int  strLen = strlen(string);
   int  total = 0;
   char ch;

   ch = string[strPos];
   if (ch != '[')
      return -1;

   while ((ch != ']') && (strPos < strLen))
   {
      ch = string[++strPos];

      if ((ch != ' ') && (ch != ']'))
      {
         number[++numPos] = 0;
         total++;
      }

      while ((ch != ' ') && (ch != ']'))
      {
         number[numPos] <<= 4;
         number[numPos] += CharToHex(ch);

         ch = string[++strPos];
      }
   }

   return total;
}

int CharToHex(char ch)
{
   int retVal = 0;

   ch = toupper(ch);

   switch (ch)
   {
      case '0':
      {
         retVal = 0;
         break;
      }
      case '1':
      {
         retVal = 1;
         break;
      }
      case '2':
      {
         retVal = 2;
         break;
      }
      case '3':
      {
         retVal = 3;
         break;
      }
      case '4':
      {
         retVal = 4;
         break;
      }
      case '5':
      {
         retVal = 5;
         break;
      }
      case '6':
      {
         retVal = 6;
         break;
      }
      case '7':
      {
         retVal = 7;
         break;
      }
      case '8':
      {
         retVal = 8;
         break;
      }
      case '9':
      {
         retVal = 9;
         break;
      }
      case 'A':
      {
         retVal = 10;
         break;
      }
      case 'B':
      {
         retVal = 11;
         break;
      }
      case 'C':
      {
         retVal = 12;
         break;
      }
      case 'D':
      {
         retVal = 13;
         break;
      }
      case 'E':
      {
         retVal = 14;
         break;
      }
      case 'F':
      {
         retVal = 15;
         break;
      }
   }

   return retVal;
}

void PrintMainMenu(void)
{
   printf("EarthBound Text Editor DK2\n");
   printf("by Tomato (tomato@starmen.net)\n");
   printf("------------------------------------------------------------\n");

   if (!romLoaded)
      printf(" No ROM Loaded\n");
   else
      printf(" ROM Loaded\n");

   printf("------------------------------------------------------------\n");

   printf("1. Load ROM        4. Change text\n");
   printf("2. Close ROM       5. Quit\n");
   printf("3. Look at text\n\n");

   printf("Your choice: ");
}

void LoadROM(FILE* romm)
{
   if (romLoaded)
   {
      printf("\nROM already loaded; close the current ROM first.\n");
      return;
   }

   printf("\nName of file to open: ");
   gets(filename);
   gets(filename);

   rom = fopen(filename, "rb+");

   if (!rom)
   {
      printf("File not opened.\n");
      return;
   }

   printf("File opened.\n");
   romLoaded = 1;

   LoadCompressedText(rom);
   printf("Dictionary loaded.\n\n");
}

void CloseROM(FILE* romm)
{
   if (!romLoaded)
   {
      printf("\nROM already closed.\n\n");
      return;
   }

   fclose(rom);

   printf("\nROM closed.\n\n");
   romLoaded = 0;
}

void DisplayText(FILE* romm)
{
   int  addr;
   int  size;
   char str[14096];

   printf("\n                                      (use 0x instead of $)\n");
   printf("  Display text located at SNES address: ");

   scanf("%x", &addr);

   GetStringAt(rom, SNESToHex(addr), str, size);
   printf("Text:\n");
   printf(str);

   printf("\n");
   printf("String length: %d\n\n", size);
}

void ChangeText(FILE* romm)
{
   int  addr;
   int  size;
   char str[14096];

   printf("\n                                      (use 0x instead of $)\n");
   printf("  Display text located at SNES address: ");

   scanf("%x", &addr);

   GetStringAt(rom, SNESToHex(addr), str, size);
   printf("Text:\n");
   printf(str);

   printf("\n");
   printf("String length: %d\n\n", size);

   printf("Type your new text: ");

   gets(str);
   gets(str);

   WriteText(rom, SNESToHex(addr), str, size);

   printf("\nNew size: %d\n\n", size);
}
