#include <stdio.h>
#include <string.h>

int CreateCodes(FILE*, FILE*, char[256][8], char[256][8]);

void main(int argc, char* argv[])
{
   FILE* rom1;
   FILE* rom2;
   char  gg[256][8];
   char  par[256][8];
   int   total;

   rom1 = fopen(argv[1], "rb");
   rom2 = fopen(argv[2], "rb");

   total = CreateCodes(rom1, rom2, gg, par);

   for (int i = 0; i < total; i++)
      printf("%s   %s\n", gg[i], par[i]);

   fclose(rom2);
   fclose(rom1);
}

int CreateCodes(FILE* currFile, FILE* origFile, char gg[256][8], char par[256][8])
{
   unsigned int  loc = 0;
   unsigned int  temp;
   int           totalCodes = 0;
   unsigned char ch1;
   unsigned char ch2;

   fseek(origFile, 0, SEEK_SET);
   fseek(currFile, 0, SEEK_SET);

   while (!feof(origFile) && !feof(currFile))
   {
      ch1 = fgetc(origFile);
      ch2 = fgetc(currFile);

      loc++;

      if (ch2 != ch1)
      {
         temp = loc + 0xc00000 - 0x200;

         sprintf(gg[totalCodes], "0000-0000");
         sprintf(par[totalCodes], "%.6X%:%.2X", temp, ch2);

         totalCodes++;
      }
   }

   return totalCodes;
}
