#include <stdio.h>
#include <string.h>
#include <allegro.h>

struct OSprite
{
   unsigned int  address;
   unsigned char width;
   unsigned char height;
   unsigned char palette;
};

void DrawTile(FILE* rom, long address, int xx, int yy, int pal, unsigned char sprite[80][64]);
void GetSprite(FILE* rom, int spriteNum, unsigned char sprite[80][64], int&, int&, int&);
void InitOSpriteArray(OSprite[]);
void GetSpriteRGB(FILE*, int, int[], int[], int[]);

int palNum = 0;
int correctColors = 1;

int main(int argc, char* argv[])
{
   FILE*         rom;
   unsigned char sprite[80][64];
   int           num = 0;
   int           kee = 9;
   int           w;
   int           h;
   int           pal;
   int           r[16];
   int           g[16];
   int           b[16];
   int           j = 0;
   int           picnum = 1;
   int           lastNum = -1;
   char          strstuff[10];
   BITMAP*       bmp;

   if (argc < 2)
   {
      printf("Usage: getsprite rom.smc\n");
      return -1;
   }

   rom = fopen(argv[1], "rb");
   if (!rom)
   {
      printf("Unable to open %s!\n", argv[1]);
      return -1;
   }

   allegro_init();
   install_keyboard();
   set_color_depth(16);
   set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0);

   while (kee != KEY_ESC)
   {

      if (num != lastNum)
      {
         clear(screen);

         j = 0;
   
         for (int yy = 0; yy < 4; yy++)
         {
            for (int xx = 0; xx < 10; xx++)
            {
               GetSprite(rom, num + j, sprite, w, h, pal);
               GetSpriteRGB(rom, pal, r, g, b);

               for (int y = 0; y < 80; y++)
               {
                  for (int x = 0; x < 64; x++)
                  {
                     putpixel(screen, (64 * xx) + x, 110 * yy + 10 + y, makecol16(r[sprite[y][x]], g[sprite[y][x]], b[sprite[y][x]]));
                  }
               }

               textprintf(screen, font, (64 * xx) + 15, yy * 110, makecol16(255, 255, 255), "%d", num + j);

               j++;
            }
         }
      }

      lastNum = num;
//      textprintf(screen, font, 0, 470, makecol16(255, 255, 255), "%d", palNum);

      kee = readkey() >> 8;

      switch(kee)
      {
         case KEY_LEFT:
         {
            num -= 40;
            if (num < 0)
               num = 0;

            break;
         }
         case KEY_RIGHT:
         {
            num += 40;
            if (num >= 1104)
               num = 1104;

            break;
         }
         case KEY_S:
         {
            bmp = create_sub_bitmap(screen, 0, 0, 640, 480);
            sprintf(strstuff, "screen%d.bmp", picnum++);

            save_bmp(strstuff, bmp, NULL);
            destroy_bitmap(bmp);

            break;
         }
         case KEY_UP:
         {
            if (!correctColors)
               palNum++;

            break;
         }
         case KEY_DOWN:
         {
            if (!correctColors)
               palNum--;

            if (palNum < 0)
               palNum = 0;

             break;
         }
         case KEY_C:
         {
  //          correctColors ^= 1;

            break;
         }
      }
   }

   fclose(rom);

   return 0;
}

void DrawTile(FILE* rom, long address, int xx, int yy, int pal, unsigned char sprite[80][64])
{
   unsigned char ch;
   int           i;
   int           y;
   char          sprLine[8][8];

   fseek(rom, address, SEEK_SET);

   for (y = 0; y < 8; y++)
   {
      ch = fgetc(rom);

      for (i = 0; i < 8; i++)
         sprLine[y][7 - i] = (ch & (1 << i)) >> i;

      ch = fgetc(rom);

      for (i = 0; i < 8; i++)
         sprLine[y][7 - i] += ((ch & (1 << i)) >> i) << 1;
   }

   for (y = 0; y < 8; y++)
   {
      ch = fgetc(rom);

      for (i = 0; i < 8; i++)
         sprLine[y][7 - i] += ((ch & (1 << i)) >> i) << 2;

      ch = fgetc(rom);

      for (i = 0; i < 8; i++)
         sprLine[y][7 - i] += ((ch & (1 << i)) >> i) << 3;
   }

   for (y = 0; y < 8; y++)
   {
      for (i = 0; i < 8; i++)
      {
         if (sprLine[y][i] == 0)
            sprite[yy + y][xx + i] = 0;
         else
            sprite[yy + y][xx + i] = sprLine[y][i];
      }
   }
}

void GetSprite(FILE* rom, int spriteNum, unsigned char sprite[80][64], int& width, int& height, int& pal)
{
   // width and height and palette will have to be predetermined and then
   // selected in this function.  Calling functions do not require this info.
   // Same goes for address of each sprite.  This function just takes a
   // sprite "number", which is determined by where it appears in the rom.

   static OSprite osprite[2000];  // DJGPP doesn't like 1144 for some reason
   static int     firstTime = 1;
   unsigned int   address   = 0;
   int            offset    = 0;

   if (firstTime == 1)
   {
      InitOSpriteArray(osprite);
      firstTime = 0;
   }

   address = osprite[spriteNum].address;
   width = osprite[spriteNum].width;
   height = osprite[spriteNum].height;
   pal = osprite[spriteNum].palette;

   for (int y = 0; y < 80; y++)
   {
      for (int x = 0; x < 64; x++)
      {
         sprite[y][x] = 0;
      }
   }

   if (!correctColors)
   {
      pal = 6;
   }

   for (int a = 0; a < height; a++)
   {
      for (int i = 0; i < width; i++)
      {
         DrawTile(rom, address + offset, i * 8, a * 8, pal, sprite);
         offset += 32;
      }
   }
}

void GetSpriteRGB(FILE* rom, int pal, int r[16], int g[16], int b[16])
{
   // Returns the r, g, and b values for each of the 16 colors for
   // the specified palette.  r[0] g[0] b[0] makes up the color 0,
   // r[1] g[1] b[1] makes up the color 1, and so on.

   int           converter[] = { 5, 7, 3, 1, 2, 4, 17 };
   int           bgrBlock;
   unsigned char ch;
   unsigned char ch2;

   if (!correctColors)
      converter[6] = palNum;

   fseek(rom, 0x30200 + converter[pal] * 32, SEEK_SET);

   // the palette at 0x30200 is the first one, and is the one used
   // by human enemies to make their faces blue.
   // i think #8 could be the moonside neony palette

   ch = fgetc(rom);
   ch = fgetc(rom);

   r[0] = 0;
   g[0] = 0;
   b[0] = 0;

   for (int i = 1; i < 16; i++)
   {
      ch = fgetc(rom);
      ch2 = fgetc(rom);

      bgrBlock = ch2 << 8;
      bgrBlock += ch;
      bgrBlock &= 0x7FFF;

      b[i] = bgrBlock >> 10;
      g[i] = (bgrBlock & 0x03e0) >> 5;
      r[i] = bgrBlock & 0x001f;

      b[i] *= 8;
      g[i] *= 8;
      r[i] *= 8;
   }
}



void InitOSpriteArray(OSprite osprite[])
{
#include "osprites.h"
}
