#include <stdio.h>

void PossessROM(FILE*);
void ExorciseROM(FILE*);
int  IsPossessed(FILE*);

int main(void)
{
   FILE* rom;

   rom = fopen("ebtest.smc", "rb+");

   PossessROM(rom);

   if (IsPossessed(rom))
      printf("Possessed!");
   else
      printf("Not possessed!");

   fclose(rom);

   return 0;
}

void PossessROM(FILE* rom)
{
   // Assumes rom is in write binary mode
   // Marks the rom as possessed.  Make sure you
   // only possess EarthBound or Mother 2 ROMs!!!!!

   fseek(rom, 0x101d0, SEEK_SET);
   fflush(rom);

   fputc('B', rom);
   fputc('o', rom);
   fputc('o', rom);
   fputc('!', rom);
}

void ExorciseROM(FILE* rom)
{
   // Assumes rom is in write binary mode
   // Marks the rom as unpossessed
   // Only run this on EarthBound or Mother 2 ROMS!!!

   fseek(rom, 0x101d0, SEEK_SET);
   fflush(rom);

   fputc(20, rom);
   fputc(20, rom);
   fputc(20, rom);
   fputc(20, rom);
}

int IsPossessed(FILE *rom)
{
   // Assumes rom is in read binary mode
   // Assumes rom is EarthBound or Mother 2 ROM
   // Returns 1 if marked as possessed, 0 if not

   char matchStr[5] = "\0\0\0\0";
   int  returnVal = 0;

   fseek(rom, 0x101d0, SEEK_SET);

   for (int i = 0; i < 4; i++)
      matchStr[i] = fgetc(rom);

   if (!strcmp(matchStr, "Boo!"))
      returnVal = 1;

   return returnVal;
}
