// EB Sprite Editor
// Written by Tomato (tomato@starmen.net)
// Requires DJGPP and Allegro to compile
// This is my precious source code.
// YOU NO STEAL

#include <stdio.h>
#include <string.h>
#include <allegro.h>
#include "ebse.h"

struct OSprite
{
   unsigned int  address;
   unsigned char width;
   unsigned char height;
   unsigned char palette;
};

void DrawTile(FILE* rom, long address, int xx, int yy, int pal, unsigned char sprite[80][64]);
void GetSprite(FILE* rom, int spriteNum, unsigned char sprite[80][64], int&, int&, int&);
void InitOSpriteArray(void);
void GetSpriteRGB(FILE*, int, int[], int[], int[]);
void ChangeTile(FILE*, unsigned int, unsigned char[8][8]);
void ChangeSprite(FILE*, int, unsigned char[80][64]);

int  IsCorrectRom(FILE*);
long FileSize(FILE*);

void DrawBackground(void);
void Flip(void);
int  IsWithin(int, int, int, int, int, int);
void DoMouseStuff(int);
void DoKeyboardStuff(void);
void ChangePixel(int, int, int);
void InitWindowStuff(void);
void CopyToClipboard(void);
void PasteToWindow(void);
void ClearWindow(int);
void FlipHorizontal(void);
void FlipVertical(void);
void DrawTomato(void);
void LoadNewSprite(void);
void GetNewMessage(void);
void SetStatus(char*, int);
void Boing(void);
void SaveSnapshot(void);
void UpdateTimers(void);

FILE*         rom;
BITMAP*       bgBuffer;
BITMAP*       background;
BITMAP*       mousePointer;
BITMAP*       mrSaturn[2];
BITMAP*       msMessage;
DATAFILE*     datafile;
FONT*         lfont;
OSprite       osprite[1300];
unsigned char mainWindow[80][64];
unsigned char clipboard[80][64];
char          saveText[25];
char*         filename;
char*         statusText;
int           mwBoundaryX;
int           mwBoundaryY;
int           pixelColor;
int           selectTimer;
int           exitFlag = 0;
int           delayTimer = 0;
int           msTimer = 0;
int           msgTimer = 0;
int           statusTimer = 0;
int           boingTimer = 0;
int           snapTimer = 0;
int           spriteNum = 0;
int           romNum;
long          fileSize;

int main(int argc, char* argv[])
{
   if (argc < 2)
   {
      printf("Usage: ebse rom.smc\n");
      return -1;
   }

   rom = fopen(argv[1], "rb+");
   if (!rom)
   {
      printf("Unable to open %s!\n", argv[1]);
      return -1;
   }

   romNum = IsCorrectRom(rom);
   if (romNum == 0)
   {
      printf("This is not a valid Mother 2 or EarthBound ROM.\n");
      return -1;
   }

   fileSize = FileSize(rom);

   allegro_init();
   install_timer();
   install_keyboard();
   install_mouse();
   install_sound(DIGI_AUTODETECT, MIDI_NONE, "");

   datafile = load_datafile("ebse.dat");

   set_color_depth(8);
   set_gfx_mode(GFX_MODEX, 320, 240, 0, 0);
   set_palette((PALETTE)datafile[PALETTE1].dat);

   text_mode(-1);
   lfont = (FONT*)datafile[LFONT].dat;

   bgBuffer = create_bitmap(320, 240);
   background = create_bitmap(320, 240);
   mousePointer = create_bitmap(8, 14);
   mrSaturn[0] = create_bitmap(16, 21);
   mrSaturn[1] = create_bitmap(16, 21);
   msMessage = create_bitmap(70, 38);

   blit((BITMAP*)datafile[BACKGROUND].dat, background, 0, 0, 0, 0, 320, 240);
   blit((BITMAP*)datafile[BACKGROUND].dat, mousePointer, 0, 240, 0, 0, 8, 14);
   blit((BITMAP*)datafile[BACKGROUND].dat, mrSaturn[0], 0, 257, 0, 0, 16, 21);
   blit((BITMAP*)datafile[BACKGROUND].dat, mrSaturn[1], 0, 281, 0, 0, 16, 21);

   InitOSpriteArray();
   InitWindowStuff();

   filename = argv[1];

   while (!key[KEY_ESC] && !exitFlag)
   {
      if (mouse_b & 1)
         DoMouseStuff(1);

      if (mouse_b & 2)
         DoMouseStuff(2);

      if (keypressed())
         DoKeyboardStuff();

      DrawBackground();
      Flip();

      if (delayTimer > 0)
         delayTimer--;
   }

   destroy_bitmap(msMessage);
   destroy_bitmap(mrSaturn[0]);
   destroy_bitmap(mrSaturn[1]);
   destroy_bitmap(bgBuffer);
   destroy_bitmap(mousePointer);
   destroy_bitmap(background);
   unload_datafile(datafile);

   fclose(rom);

   return 0;
}

void DrawBackground(void)
{
   int   color;
   int   xx;
   int   yy;
   int   y;
   int   x;
   char* romType[] = {
      "",
      "EarthBound ROM",
      "Mother 2 ROM",
      "EarthBound ROM (bad)"
   };

   clear(bgBuffer);

   blit(background, bgBuffer, 0, 0, 0, 0, 320, 240);

   rectfill(bgBuffer, 19, 18, 146, 177, 239);
   rectfill(bgBuffer, 169, 18, 232, 97, 239);

   textprintf(bgBuffer, lfont, 167, 106, 238, "Sprite %d", spriteNum);
   textout(bgBuffer, lfont, filename, 168, 187, 238);
   textout(bgBuffer, lfont, romType[romNum], 168, 197, 238);
   textprintf(bgBuffer, lfont, 168, 207, 238, "%ld bytes", fileSize);

   for (y = 0; y < mwBoundaryY; y++)
   {
      for (x = 0; x < mwBoundaryX; x++)
      {
         xx = x * 2 + 19;
         yy = y * 2 + 18;
         color = mainWindow[y][x] + 240;

         rectfill(bgBuffer, xx, yy, xx + 1, yy + 1, color);
         putpixel(bgBuffer, 169 + x, 18 + y, color);
      }
   }

   for (y = 0; y < 2; y++)
   {
      for (x = 0; x < 8; x++)
      {
         xx = 21 + x * 16;
         yy = 189 + y * 10;
         color = 240 + 8 * y + x;

         rectfill(bgBuffer, xx, yy, xx + 10, yy + 6, color);
         rect(bgBuffer, xx, yy, xx + 10, yy + 6, 237);
      }
   }

   UpdateTimers();

   draw_sprite(bgBuffer, mousePointer, mouse_x, mouse_y);
}

void Flip(void)
{
   blit(bgBuffer, screen, 0, 0, 0, 0, 320, 240);
}

void DoMouseStuff(int button)
{
   int  lastColor = pixelColor;
   int  x         = mouse_x;
   int  y         = mouse_y;

   if (button == 1)
   {
      // Exit box
      if (IsWithin(x, y, 164, 165, 237, 182))
         exitFlag = 1;

      // Boing! box
      if (IsWithin(x, y, 164, 143, 237, 161))
         Boing();

      // Save box
      if (IsWithin(x, y, 164, 122, 237, 140))
      {
         ChangeSprite(rom, spriteNum, mainWindow);
         SetStatus("Sprite saved.", 240);
      }

      // Main drawing window
      if (IsWithin(x, y, 19, 18, 147, 179))
         ChangePixel(x, y, pixelColor);

      // Copy button
      if (IsWithin(x, y, 14, 215, 32, 231))
      {
         CopyToClipboard();
         SetStatus("Sprite copied.", 240);
      }

      // Paste button
      if (IsWithin(x, y, 34, 215, 52, 231))
      {
         PasteToWindow();
         SetStatus("Sprite pasted.", 240);
      }

      // Clear button
      if (IsWithin(x, y, 54, 215, 72, 231))
      {
         ClearWindow(pixelColor);
         SetStatus("Sprite cleared.", 240);
      }

      // Flip horizontal button
      if (IsWithin(x, y, 74, 215, 92, 231))
      {
         FlipHorizontal();
         SetStatus("Sprite H-flipped.", 240);
      }

      // Flip vertical button
      if (IsWithin(x, y, 94, 215, 112, 231))
      {
         FlipVertical();
         SetStatus("Sprite V-flipped.", 240);
      }

      // Tomato button
      if (IsWithin(x, y, 114, 215, 132, 231))
      {
         DrawTomato();
         SetStatus("Boo.", 240);
      }

      // Snapshot button
      if (IsWithin(x, y, 134, 215, 152, 231))
      {
         SaveSnapshot();

         sprintf(saveText, "sprite%d.bmp saved.", spriteNum);
         SetStatus(saveText, 240);
      }

      // Color 0
      if (IsWithin(x, y, 21, 189, 31, 195))
         pixelColor = 0;

      // Color 1
      if (IsWithin(x, y, 37, 189, 47, 195))
         pixelColor = 1;

      // Color 2
      if (IsWithin(x, y, 53, 189, 63, 195))
         pixelColor = 2;

      // Color 3
      if (IsWithin(x, y, 69, 189, 79, 195))
         pixelColor = 3;

      // Color 4
      if (IsWithin(x, y, 85, 189, 95, 195))
         pixelColor = 4;

      // Color 5
      if (IsWithin(x, y, 101, 189, 111, 195))
         pixelColor = 5;

      // Color 6
      if (IsWithin(x, y, 117, 189, 127, 195))
         pixelColor = 6;

      // Color 7
      if (IsWithin(x, y, 133, 189, 143, 195))
         pixelColor = 7;

      // Color 8
      if (IsWithin(x, y, 21, 199, 31, 205))
         pixelColor = 8;

      // Color 9
      if (IsWithin(x, y, 37, 199, 47, 205))
      pixelColor = 9;

      // Color 10
      if (IsWithin(x, y, 53, 199, 63, 205))
         pixelColor = 10;

      // Color 11
      if (IsWithin(x, y, 69, 199, 79, 205))
         pixelColor = 11;

      // Color 12
      if (IsWithin(x, y, 85, 199, 95, 205))
         pixelColor = 12;

      // Color 13
      if (IsWithin(x, y, 101, 199, 111, 205))
         pixelColor = 13;

      // Color 14
      if (IsWithin(x, y, 117, 199, 127, 205))
         pixelColor = 14;

      // Color 15
      if (IsWithin(x, y, 133, 199, 143, 205))
         pixelColor = 15;
   }
   else if (button == 2)
   {
      // Main drawing window
      if (IsWithin(x, y, 19, 18, 147, 179))
         ChangePixel(x, y, 0);
   }

   if (pixelColor != lastColor)
      selectTimer = 0;
}

void DoKeyboardStuff(void)
{
   int lastSprNum = spriteNum;
   int kee        = readkey() >> 8;
   int palNum;
   int width;
   int height;

   switch (kee)
   {
      case KEY_LEFT:
      {
         spriteNum--;
         if (spriteNum < 0)
            spriteNum = 0;

         break;
      }
      case KEY_RIGHT:
      {
         spriteNum++;
         if (spriteNum > 1143)
            spriteNum = 1143;

         break;
      }
      case KEY_UP:
      {
         spriteNum += 25;
         if (spriteNum > 1143)
            spriteNum = 1143;

         break;
      }
      case KEY_DOWN:
      {
         spriteNum -= 25;
         if (spriteNum < 0)
            spriteNum = 0;

         break;
      }
   }

   if (spriteNum != lastSprNum)
      LoadNewSprite();
}

int IsWithin(int x, int y, int xx1, int yy1, int xx2, int yy2)
{
   if ((x >= xx1) && (x <= xx2) && (y >= yy1) && (y <= yy2))
      return 1;
   else
      return 0;
}

void ChangePixel(int x, int y, int col)
{
  x -= 19;
  y -= 18;

  x /= 2;
  y /= 2;

  if ((x < mwBoundaryX) && (y < mwBoundaryY))
     mainWindow[y][x] = col;
}

void InitWindowStuff(void)
{
   RGB pal;

   mwBoundaryX = 50;
   mwBoundaryY = 40;
   pixelColor = 1;

   for (int y = 0; y < 80; y++)
   {
      for (int x = 0; x < 64; x++)
      {
         mainWindow[y][x] = 0;
         clipboard[y][x] = 0;
      }
   }

   pal.r = 0;
   pal.g = 0;
   pal.b = 0;
   set_color(237, &pal);

   pal.r = 63;
   pal.g = 63;
   pal.b = 63;
   set_color(238, &pal);

   pal.r = 20;
   pal.g = 20;
   pal.b = 20;
   set_color(239, &pal);

   LoadNewSprite();
   GetNewMessage();
   SetStatus("Welcome!", 180);

   selectTimer = 0;
}

void CopyToClipboard(void)
{
   for (int y = 0; y < 80; y++)
      for (int x = 0; x < 64; x++)
         clipboard[y][x] = 0;
  
   for (int y = 0; y < mwBoundaryY; y++)
      for (int x = 0; x < mwBoundaryX; x++)
         clipboard[y][x] = mainWindow[y][x];
}

void PasteToWindow(void)
{
   for (int y = 0; y < 80; y++)
      for (int x = 0; x < 64; x++)
         mainWindow[y][x] = clipboard[y][x];
}

void ClearWindow(int col)
{
   for (int y = 0; y < 80; y++)
      for (int x = 0; x < 64; x++)
         mainWindow[y][x] = col;
}

void FlipHorizontal(void)
{
   unsigned char temp[80][64];
   int           y;
   int           x;

   if (delayTimer != 0)
      return;

   for (y = 0; y < 80; y++)
      for (x = 0; x < 64; x++)
         temp[y][x] = 0;

   for (y = 0; y < mwBoundaryY; y++)
      for (x = 0; x < mwBoundaryX; x++)
         temp[y][mwBoundaryX - x - 1] = mainWindow[y][x];

   for (y = 0; y < 80; y++)
      for (x = 0; x < 64; x++)
         mainWindow[y][x] = temp[y][x];

   delayTimer = 60;
}

void FlipVertical(void)
{
   unsigned char temp[80][64];
   int           y;
   int           x;

   if (delayTimer != 0)
      return;

   for (y = 0; y < mwBoundaryY; y++)
      for (x = 0; x < mwBoundaryX; x++)
         temp[mwBoundaryY - y - 1][x] = mainWindow[y][x];

   for (y = 0; y < 80; y++)
      for (x = 0; x < 64; x++)
         mainWindow[y][x] = temp[y][x];

   delayTimer = 60;
}

void DrawTomato(void)
{
   unsigned char newSprite[80][64] =
   { {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
     {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
     {  0,  0,  0,  0,  0, 15,  0,  0,  0,  0, 15, 15,  0,  0,  0,  0 },
     {  0,  0,  0,  0, 15,  4, 15,  0,  0, 15,  4,  4, 15,  0,  0,  0 },
     {  0,  0,  0,  0, 15,  4,  4, 15, 15,  4,  4, 15,  0,  0,  0,  0 },
     {  0,  0,  0,  0,  0, 15,  4,  4,  4,  4, 15,  0,  0,  0,  0,  0 },
     {  0,  0,  0, 15, 15, 15,  4,  4,  4,  4,  4, 15,  0,  0,  0,  0 },
     {  0,  0, 15, 11, 15,  4,  4, 15, 15, 15,  4,  4, 11, 15, 15,  0 },
     {  0, 15, 11, 11, 11, 15, 15, 11, 11, 11, 15, 15, 11, 11, 15,  0 },
     { 15, 11, 11, 11,  1,  1, 11, 11, 11, 11,  1,  1, 11, 11, 11, 15 },
     { 15, 11, 11,  1,  1,  1,  1, 11, 11,  1,  1,  1,  1, 11, 11, 15 },
     { 15, 11, 11,  1, 15, 15,  1, 11, 11,  1, 15, 15,  1, 11, 11, 15 },
     { 15, 11, 11,  1, 15, 15,  1, 11, 11,  1, 15, 15,  1, 11, 11, 15 },
     { 15, 11, 11, 11, 15, 15, 11, 11, 11, 11, 15, 15, 11, 11, 11, 15 },
     { 15, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 15 },
     { 15, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 15 },
     { 15, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 15 },
     { 15, 11, 11, 11, 11, 15, 15, 15, 15, 15, 15, 11, 11, 11, 11, 15 },
     {  0, 15, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 15,  0 },
     {  0,  0, 15, 15, 11, 11, 11, 11, 11, 11, 11, 11, 11, 15,  0,  0 },
     {  0,  0,  0,  0, 15, 15, 15, 15, 15, 15, 15, 15, 15,  0,  0,  0 },
     {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
     {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
     {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 } };

   for (int y = 0; y < 80; y++)
      for (int x = 0; x < 64; x++)
         mainWindow[y][x] = newSprite[y][x];
}

void LoadNewSprite(void)
{
   int width;
   int height;
   int palNum;
   int r[16];
   int g[16];
   int b[16];
   RGB pal;

   for (int y = 0; y < 80; y++)
      for (int x = 0; x < 64; x++)
         mainWindow[y][x] = 0;

   GetSprite(rom, spriteNum, mainWindow, width, height, palNum);
   GetSpriteRGB(rom, palNum, r, g, b);
   mwBoundaryX = width * 8;
   mwBoundaryY = height * 8;

   for (int i = 0; i < 16; i++)
   {
      pal.r = r[i] / 4;
      pal.g = g[i] / 4;
      pal.b = b[i] / 4;

      set_color(240 + i, &pal);
   }
}

void GetNewMessage(void)
{
   static int num  = -1;
   int        x[7] = { 19, 89, 159, 229, 19, 89, 159 };
   int        y[7] = { 240, 240, 240, 240, 278, 278, 278 };

   num++;
   num %= 7;

   blit((BITMAP*)datafile[BACKGROUND].dat, msMessage, x[num], y[num], 0, 0, 70, 38);
}

void SetStatus(char* str, int statusLen)
{
   statusText = str;
   statusTimer = statusLen;
}

void Boing(void)
{
   if (boingTimer > 0)
      return;
   else
   {
      play_sample((SAMPLE*)datafile[KILL_YOU].dat, 127, 127, 1000, 0);

      boingTimer = 360;
      SetStatus("Mr. Saturn keeeeel you!", 360);
   }

}

void SaveSnapshot(void)
{
   char    saveName[25];
   BITMAP* tempBitmap;
   RGB     pal[256];
   RGB     temp;
   int     i;

   sprintf(saveName, "sprite%d.bmp", spriteNum);

   tempBitmap = create_bitmap(mwBoundaryX, mwBoundaryY);

   for (int y = 0; y < mwBoundaryY; y++)
      for (int x = 0; x < mwBoundaryX; x++)
         putpixel(tempBitmap, x, y, mainWindow[y][x]);

   for (i = 0; i < 256; i++)
      pal[i].r = pal[i].g = pal[i].b = 0;

   for (i = 0; i < 16; i++)
   {
      get_color(240 + i, &temp);

      pal[i] = temp;
   }

   save_bmp(saveName, tempBitmap, pal);

   destroy_bitmap(tempBitmap);

   snapTimer = 180;
}

void UpdateTimers(void)
{
   int x;
   int y;

   selectTimer++;
   if (selectTimer > 180)
      selectTimer = 0;

   x = 21 + (pixelColor % 8) * 16;
   y = 189 + (pixelColor / 8) * 10;

   if (selectTimer < 90)
      rect(bgBuffer, x, y, x + 10, y + 6, 238);
   else
      rect(bgBuffer, x, y, x + 10, y + 6, 237);

   msTimer++;
   if (msTimer >= 200)
      msTimer = 0;

   draw_sprite(bgBuffer, mrSaturn[msTimer / 100], 266, 96);

   msgTimer++;
   if (msgTimer >= 2000)
   {
      msgTimer = 0;
      GetNewMessage();
   }

   draw_sprite(bgBuffer, msMessage, 241, 144);

   snapTimer--;
   if (snapTimer < 0)
      snapTimer = 0;

   statusTimer--;
   if (statusTimer < 0)
      statusTimer = 0;

   if (statusTimer)
      textout(bgBuffer, lfont, statusText, 168, 217, 238);

    boingTimer--;
    if (boingTimer < 0)
       boingTimer = 0;
}




void DrawTile(FILE* rom, long address, int xx, int yy, int pal, unsigned char sprite[80][64])
{
   unsigned char ch;
   int           i;
   int           y;
   char          sprLine[8][8];

   fseek(rom, address, SEEK_SET);

   for (y = 0; y < 8; y++)
   {
      ch = fgetc(rom);

      for (i = 0; i < 8; i++)
         sprLine[y][7 - i] = (ch & (1 << i)) >> i;

      ch = fgetc(rom);

      for (i = 0; i < 8; i++)
         sprLine[y][7 - i] += ((ch & (1 << i)) >> i) << 1;
   }

   for (y = 0; y < 8; y++)
   {
      ch = fgetc(rom);

      for (i = 0; i < 8; i++)
         sprLine[y][7 - i] += ((ch & (1 << i)) >> i) << 2;

      ch = fgetc(rom);

      for (i = 0; i < 8; i++)
         sprLine[y][7 - i] += ((ch & (1 << i)) >> i) << 3;
   }

   for (y = 0; y < 8; y++)
   {
      for (i = 0; i < 8; i++)
      {
         if (sprLine[y][i] == 0)
            sprite[yy + y][xx + i] = 0;
         else
            sprite[yy + y][xx + i] = sprLine[y][i];
      }
   }
}

void GetSprite(FILE* rom, int spriteNum, unsigned char sprite[80][64], int& width, int& height, int& pal)
{
   // width and height and palette will have to be predetermined and then
   // selected in this function.  Calling functions do not require this info.
   // Same goes for address of each sprite.  This function just takes a
   // sprite "number", which is determined by where it appears in the rom.

   unsigned int  address   = 0;
   int           offset    = 0;

   address = osprite[spriteNum].address;
   width = osprite[spriteNum].width;
   height = osprite[spriteNum].height;
   pal = osprite[spriteNum].palette;

   for (int y = 0; y < 80; y++)
   {
      for (int x = 0; x < 64; x++)
      {
         sprite[y][x] = 0;
      }
   }

   for (int a = 0; a < height; a++)
   {
      for (int i = 0; i < width; i++)
      {
         DrawTile(rom, address + offset, i * 8, a * 8, pal, sprite);
         offset += 32;
      }
   }
}

void GetSpriteRGB(FILE* rom, int pal, int r[16], int g[16], int b[16])
{
   int           converter[] = { 5, 7, 3, 1, 2, 4, 17 };
   int           bgrBlock;
   unsigned char ch;
   unsigned char ch2;

   // the palette at 0x30200 is the first one, and is the one used
   // by human enemies to make their faces blue.
   // i think #8 could be the moonside neony palette

   fseek(rom, 0x30200 + converter[pal] * 32, SEEK_SET);

   ch = fgetc(rom);
   ch = fgetc(rom);

   r[0] = 0;
   g[0] = 0;
   b[0] = 0;

   for (int i = 1; i < 16; i++)
   {
      ch = fgetc(rom);
      ch2 = fgetc(rom);

      bgrBlock = ch2 << 8;
      bgrBlock += ch;
      bgrBlock &= 0x7FFF;

      b[i] = bgrBlock >> 10;
      g[i] = (bgrBlock & 0x03e0) >> 5;
      r[i] = bgrBlock & 0x001f;

      b[i] *= 8;
      g[i] *= 8;
      r[i] *= 8;
   }
}

void ChangeTile(FILE* rom, unsigned int loc, unsigned char newTile[8][8])
{
   unsigned char num;
   unsigned char num2;
   unsigned char num3;
   unsigned char num4;

   fseek(rom, loc, SEEK_SET);
   fflush(rom);

   for (int j = 0; j < 8; j++)
   {
      num = 0;
      num2 = 0;
      num3 = 0;
      num4 = 0;

      for (int i = 0; i < 8; i++)
      {
         num += ((newTile[j][i] & 0x01) << (7 - i));
         num2 += (((newTile[j][i] & 0x02) >> 1) << (7 - i));
         num3 += (((newTile[j][i] & 0x04) >> 2) << (7 - i));
         num4 += (((newTile[j][i] & 0x08) >> 3) << (7 - i));
      }

      fseek(rom, loc, SEEK_SET);
      fputc(num, rom);
      fputc(num2, rom);

      fseek(rom, loc + 0x10, SEEK_SET);
      fputc(num3, rom);
      fputc(num4, rom);

      loc += 2;
   }
}

void ChangeSprite(FILE* rom, int spriteNum, unsigned char newTile[80][64])
{
   // Assumes rom is in write binary format.
   // spriteNum is the raw sprite number to be edited.  This is the #
   // associated with the original sprite viewer program, and goes from 0
   // to 1143.
   // newTile is the new sprite info to be stored over the sprite you
   // indicate.  Width and height are automatically trimmed to the correct
   // size.

   // NOTE: I gotta do something about that static array here, there's one
   // in the getsprite routine too, and that's A LOT of wasted memory,
   // plus creating static variables like this is bad design.  I'll figure
   // something out later.

   unsigned char temp[8][8];
   int           offset = 0;
   int           sx;
   int           sy;
   unsigned int  loc;
   unsigned char width;
   unsigned char height;

   loc = osprite[spriteNum].address;
   width = osprite[spriteNum].width;
   height = osprite[spriteNum].height;
 
   for (int y = 0; y < height; y++)
   {
      for (int x = 0; x < width; x++)
      {
         sy = y * 8;
         sx = x * 8;
         
         for (int iy = sy; iy < sy + 8; iy++)
         {
            for (int ix = sx; ix < sx + 8; ix++)
            {
               temp[iy - sy][ix - sx] = newTile[iy][ix];
            }
         }

         ChangeTile(rom, loc + offset, temp);
         offset += 32;
      }
   }
}

void InitOSpriteArray(void)
{
#include "osprites.h"
}

int IsCorrectRom(FILE* rom)
{
   // Assumes rom is in read binary mode
   // Return Values:
   // 0 - Unknown/invalid ROM
   // 1 - EarthBound ROM
   // 2 - Mother 2 ROM
   // 3 - EarthBound ROM version 2

   char matchStr[16];
   int  returnVal = 0;
   int  i;

   for (i = 0; i < 16; i++)
      matchStr[i] = '\0';

   fseek(rom, 0x101c0, SEEK_SET);

   for (i = 0; i < 15; i++)
      matchStr[i] = fgetc(rom);

   if (!strcmp(matchStr, "EARTH BOUND (J)"))
      returnVal = 1;
   else if (!strcmp(matchStr, "MOTHER-2       "))
      returnVal = 2;
   else if (!strcmp(matchStr, "EARTH BOUND    "))
      returnVal = 3;

   return returnVal;
}

long FileSize(FILE* rom)
{
   long returnVal;

   fseek(rom, 0, SEEK_END);
   returnVal = ftell(rom);

   return returnVal;
}
