#include <stdio.h>
#include <string.h>

int  IsCorrectRom(FILE*);
long FileSize(FILE*);
void FixBadRom(FILE*);

int main(int argc, char* argv[])
{
   FILE* rom;
   int   result;

   if (argc < 2)
   {
      printf("Usage: romcheck rom.smc\n");
      return -1;
   }

   rom = fopen(argv[1], "rb+");
   if (!rom)
   {
      printf("Unable to open %s!\n", argv[1]);
      return -1;
   }

   result = IsCorrectRom(rom);

   if (result == 0)
      printf("Unknown/invalid ROM loaded.\n");
   else if (result == 1)
      printf("EarthBound ROM loaded.\n");
   else if (result == 2)
      printf("Mother 2 ROM loaded.\n");
   else if (result == 3)
   {
      printf("EarthBound ROM version 2 detected, fixing.\n");
      FixBadRom(rom);
   }

   printf("%u bytes\n", FileSize(rom));

   fclose(rom);

   return 0;
}

int IsCorrectRom(FILE* rom)
{
   // Assumes rom is in read binary mode
   // Return Values:
   // 0 - Unknown/invalid ROM
   // 1 - EarthBound ROM
   // 2 - Mother 2 ROM
   // 3 - EarthBound ROM version 2

   char matchStr[16];
   int  returnVal = 0;
   int  i;

   for (i = 0; i < 16; i++)
      matchStr[i] = '\0';

   fseek(rom, 0x101c0, SEEK_SET);

   for (i = 0; i < 15; i++)
      matchStr[i] = fgetc(rom);

   if (!strcmp(matchStr, "EARTH BOUND (J)"))
      returnVal = 1;
   else if (!strcmp(matchStr, "MOTHER-2       "))
      returnVal = 2;
   else if (!strcmp(matchStr, "EARTH BOUND    "))
      returnVal = 3;

   return returnVal;
}

long FileSize(FILE* rom)
{
   long returnVal;

   fseek(rom, 0, SEEK_END);
   returnVal = ftell(rom);

   return returnVal;
}

void FixBadRom(FILE* rom)
{
   // Assumes rom is in write binary mode
   // This takes version 2 of the ROM and patches it to make it into
   // version 1.  This is because either version 2 is a actually just a
   // bad dump of EB (didn't it have some sort of protection?) or
   // something.  It's a lot simpler to do this than rewrite a whole
   // bunch of code.  Only about 24 bytes are different between these
   // two versions, including data in the header, which makes me think
   // this was a bad ROM.

   fseek(rom, 0x4, SEEK_SET);
   fflush(rom);
   fputc(221, rom);

   fseek(rom, 0x5, SEEK_SET);
   fflush(rom);
   fputc(2, rom);

   fseek(rom, 0x8, SEEK_SET);
   fflush(rom);
   fputc(0, rom);

   fseek(rom, 0x9, SEEK_SET);
   fflush(rom);
   fputc(0, rom);

   fseek(rom, 0xa, SEEK_SET);
   fflush(rom);
   fputc(0, rom);

   fseek(rom, 0x2a1d, SEEK_SET);
   fflush(rom);
   fputc(234, rom);

   fseek(rom, 0x2a1e, SEEK_SET);
   fflush(rom);
   fputc(234, rom);

   fseek(rom, 0x859d, SEEK_SET);
   fflush(rom);
   fputc(48, rom);

   fseek(rom, 0x85a8, SEEK_SET);
   fflush(rom);
   fputc(48, rom);

   fseek(rom, 0xa328, SEEK_SET);
   fflush(rom);
   fputc(48, rom);

   fseek(rom, 0xa341, SEEK_SET);
   fflush(rom);
   fputc(128, rom);

   fseek(rom, 0x101cc, SEEK_SET);
   fflush(rom);
   fputc(40, rom);

   fseek(rom, 0x101cd, SEEK_SET);
   fflush(rom);
   fputc(74, rom);

   fseek(rom, 0x101ce, SEEK_SET);
   fflush(rom);
   fputc(41, rom);

   fseek(rom, 0x101d5, SEEK_SET);
   fflush(rom);
   fputc(146, rom);

   fseek(rom, 0x201e7, SEEK_SET);
   fflush(rom);
   fputc(234, rom);

   fseek(rom, 0x201e8, SEEK_SET);
   fflush(rom);
   fputc(169, rom);

   fseek(rom, 0x201e9, SEEK_SET);
   fflush(rom);
   fputc(0, rom);

   fseek(rom, 0x201ea, SEEK_SET);
   fflush(rom);
   fputc(0, rom);

   fseek(rom, 0x3ffd6, SEEK_SET);
   fflush(rom);
   fputc(234, rom);

   fseek(rom, 0x3ffd7, SEEK_SET);
   fflush(rom);
   fputc(169, rom);

   fseek(rom, 0x3ffd8, SEEK_SET);
   fflush(rom);
   fputc(0, rom);

   fseek(rom, 0x3ffd9, SEEK_SET);
   fflush(rom);
   fputc(0, rom);

   fseek(rom, 0x3ffda, SEEK_SET);
   fflush(rom);
   fputc(128, rom);
}
