#include <stdio.h>

void PullDefaultNames(FILE*, char[80][10]);

int main(void)
{
   FILE* rom;
   char  names[49][7];

   rom = fopen("ebtest.smc", "rb");

   PullDefaultNames(rom, names);

   for (int i = 0; i < 49; i++)
      printf("%s\n", names[i]);

   fclose(rom);

   return 0;
}

void PullDefaultNames(FILE* rom, char names[80][10])
{
   // Assumes rom is in read binary mode

   unsigned char ch;

   fseek(rom, 0x15f6cf, SEEK_SET);

   for (int i = 0; i < 49; i++)
   {
      for (int j = 0; j < 6; j++)
      {
         ch = fgetc(rom);

         if (ch != 0)
            names[i][j] = ch - 0x30;
         else
            names[i][j] = 0;
      }

      names[i][6] = 0;
   }
}
