#include <stdio.h>

int CreateIPS(FILE*, FILE*, char*, int*&);

int main(int argc, char* argv[])
{
   FILE* openROM;
   FILE* compareROM;
   int   result;
   int*  currByte;

   if (argc < 4)
   {
      printf("Usage: createips source1 source2 target\n");
      return -1;
   }

   openROM = fopen(argv[1], "rb");
   if (!openROM)
   {
      printf("Unable to open %s.\n", argv[1]);
      return -1;
   }

   compareROM = fopen(argv[2], "rb");
   if (!compareROM)
   {
      printf("Unable to open %s.\n", argv[2]);
      return -1;
   }

   result = CreateIPS(openROM, compareROM, argv[3], currByte);
   if (result == -1)
   {
      printf("Error creating IPS file.\n");
      return -1;
   }
   else
      printf("IPS created.  Have a nice day!\n");

   fclose(compareROM);
   fclose(openROM);

   return 0;
}

int CreateIPS(FILE* rom1, FILE* rom2, char* targetName, int*& currByte)
{
   // Creates an IPS file by comparing two files.  It's assumed rom1
   // is already open, and in read binary mode.  rom1 is usually the
   // rom you have open, in other words, the modified rom.  rom2 is the
   // original rom, or the rom you're comparing to.  Don't mix them up,
   // heh.

   // Note that IPS files created with this aren't the most efficient
   // in terms the of filesize of output files.  But, since most of the
   // stuff done in PK Hack won't require RLE encoding, this is good
   // enough.  Well, maybe when we get to major sprite editing I'll
   // try RLE encoding.

   // Extra note: It's probably a really good idea to make sure ahead
   // of time that the file sizes of the two files are identical, and
   // that both are of the same type of file, i.e. both are EarthBound
   // ROMs, or both are Mother 2 ROMs.

   // This program returns -1 if the files are identical.  0 if everything
   // turned out okay, and the IPS file was created.

   // currByte stores the current byte being checked.  This is only useful
   // if you're doing a "live" update, with a progress bar or something.  Of
   // course that means this has to be in its own thread.  Otherwise, this
   // argument is useless so just give it a dummy variable.

   FILE* target;
   char  ch1;
   char  ch2;
   int   loc = 0;
   int   totalDiff = 0;

   // Now, let's create the IPS file
   target = fopen(targetName, "wb");

   fputc('P', target);
   fputc('A', target);
   fputc('T', target);
   fputc('C', target);
   fputc('H', target);

   fseek(rom1, 0, SEEK_SET);
   fseek(rom2, 0, SEEK_SET);

   currByte = &loc;

   while (!feof(rom1) && !feof(rom2))
   {
      ch1 = fgetc(rom1);
      ch2 = fgetc(rom2);

      if (ch1 != ch2)
      {
         fputc((loc >> 16) & 255, target);
         fputc((loc >> 8) & 255, target);
         fputc(loc & 255, target);

         fputc(0, target);
         fputc(1, target);

         fputc(ch1, target);
      }

      loc++;
   }

   fputc('E', target);
   fputc('O', target);
   fputc('F', target);

   fclose(target);

   return 0;
}
